/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchAlias;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ListAliasesResult
implements JsonSerializable<ListAliasesResult> {
    private final List<SearchAlias> aliases;

    public ListAliasesResult(List<SearchAlias> aliases) {
        this.aliases = aliases;
    }

    public List<SearchAlias> getAliases() {
        return this.aliases;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.aliases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ListAliasesResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListAliasesResult)jsonReader.readObject(reader -> {
            boolean aliasesFound = false;
            List aliases = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    aliases = reader.readArray(reader1 -> SearchAlias.fromJson(reader1));
                    aliasesFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (aliasesFound) {
                ListAliasesResult deserializedListAliasesResult = new ListAliasesResult(aliases);
                return deserializedListAliasesResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!aliasesFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

