/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ListIndexersResult
implements JsonSerializable<ListIndexersResult> {
    private final List<SearchIndexer> indexers;

    public ListIndexersResult(List<SearchIndexer> indexers) {
        this.indexers = indexers;
    }

    public List<SearchIndexer> getIndexers() {
        return this.indexers;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.indexers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ListIndexersResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListIndexersResult)jsonReader.readObject(reader -> {
            boolean indexersFound = false;
            List indexers = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    indexers = reader.readArray(reader1 -> SearchIndexer.fromJson(reader1));
                    indexersFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (indexersFound) {
                ListIndexersResult deserializedListIndexersResult = new ListIndexersResult(indexers);
                return deserializedListIndexersResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!indexersFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

