/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SimilarityAlgorithm;
import java.io.IOException;

public final class ClassicSimilarityAlgorithm
extends SimilarityAlgorithm {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.ClassicSimilarity";

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        return jsonWriter.writeEndObject();
    }

    public static ClassicSimilarityAlgorithm fromJson(JsonReader jsonReader) throws IOException {
        return (ClassicSimilarityAlgorithm)jsonReader.readObject(reader -> {
            ClassicSimilarityAlgorithm deserializedClassicSimilarityAlgorithm = new ClassicSimilarityAlgorithm();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.ClassicSimilarity'. The found '@odata.type' was '" + odataType + "'.");
                }
                reader.skipChildren();
            }
            return deserializedClassicSimilarityAlgorithm;
        });
    }
}

