/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkillV1;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkillV3;
import com.azure.search.documents.indexes.models.EntityCategory;
import com.azure.search.documents.indexes.models.EntityRecognitionSkillLanguage;
import com.azure.search.documents.indexes.models.EntityRecognitionSkillVersion;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class EntityRecognitionSkill
extends SearchIndexerSkill {
    private static final ClientLogger LOGGER = new ClientLogger(EntityRecognitionSkill.class);
    private final EntityRecognitionSkillVersion version;
    private final EntityRecognitionSkillV1 v1Skill;
    private final EntityRecognitionSkillV3 v3Skill;

    EntityRecognitionSkill(EntityRecognitionSkillV1 v1Skill) {
        super(v1Skill.getInputs(), v1Skill.getOutputs());
        this.version = EntityRecognitionSkillVersion.V1;
        this.v1Skill = v1Skill;
        this.v3Skill = null;
    }

    EntityRecognitionSkill(EntityRecognitionSkillV3 v3Skill) {
        super(v3Skill.getInputs(), v3Skill.getOutputs());
        this.version = EntityRecognitionSkillVersion.V3;
        this.v1Skill = null;
        this.v3Skill = v3Skill;
    }

    public EntityRecognitionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        this(inputs, outputs, EntityRecognitionSkillVersion.V1);
    }

    public EntityRecognitionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, EntityRecognitionSkillVersion version) {
        super(inputs, outputs);
        this.version = Objects.requireNonNull(version, "'version' cannot be null.");
        if (version == EntityRecognitionSkillVersion.V1) {
            this.v1Skill = new EntityRecognitionSkillV1(inputs, outputs);
            this.v3Skill = null;
        } else {
            this.v1Skill = null;
            this.v3Skill = new EntityRecognitionSkillV3(inputs, outputs);
        }
    }

    public EntityRecognitionSkillVersion getSkillVersion() {
        return this.version;
    }

    public List<EntityCategory> getCategories() {
        if (this.v1Skill != null) {
            return this.v1Skill.getCategories();
        }
        List<String> categories = this.v3Skill.getCategories();
        if (categories == null) {
            return null;
        }
        return categories.stream().map(EntityCategory::fromString).collect(Collectors.toList());
    }

    public EntityRecognitionSkill setCategories(List<EntityCategory> categories) {
        if (this.v1Skill != null) {
            this.v1Skill.setCategories(categories);
        } else if (categories == null) {
            this.v3Skill.setCategories(null);
        } else {
            this.v3Skill.setCategories(categories.stream().map(ExpandableStringEnum::toString).collect(Collectors.toList()));
        }
        return this;
    }

    public EntityRecognitionSkillLanguage getDefaultLanguageCode() {
        return this.v1Skill != null ? this.v1Skill.getDefaultLanguageCode() : EntityRecognitionSkillLanguage.fromString(this.v3Skill.getDefaultLanguageCode());
    }

    public EntityRecognitionSkill setDefaultLanguageCode(EntityRecognitionSkillLanguage defaultLanguageCode) {
        if (this.v1Skill != null) {
            this.v1Skill.setDefaultLanguageCode(defaultLanguageCode);
        } else {
            this.v3Skill.setDefaultLanguageCode(defaultLanguageCode == null ? null : defaultLanguageCode.toString());
        }
        return this;
    }

    public Boolean areTypelessEntitiesIncluded() {
        return this.v1Skill != null ? this.v1Skill.isIncludeTypelessEntities() : null;
    }

    public EntityRecognitionSkill setTypelessEntitiesIncluded(Boolean includeTypelessEntities) {
        if (includeTypelessEntities != null && this.version == EntityRecognitionSkillVersion.V3) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("EntityRecognitionSkill using V3 doesn't support 'includeTypelessEntities'."));
        }
        if (this.v1Skill != null) {
            this.v1Skill.setIncludeTypelessEntities(includeTypelessEntities);
        }
        return this;
    }

    public Double getMinimumPrecision() {
        return this.v1Skill != null ? this.v1Skill.getMinimumPrecision() : this.v3Skill.getMinimumPrecision();
    }

    public EntityRecognitionSkill setMinimumPrecision(Double minimumPrecision) {
        if (this.v1Skill != null) {
            this.v1Skill.setMinimumPrecision(minimumPrecision);
        } else {
            this.v3Skill.setMinimumPrecision(minimumPrecision);
        }
        return this;
    }

    public String getModelVersion() {
        return this.v1Skill != null ? null : this.v3Skill.getModelVersion();
    }

    public EntityRecognitionSkill setModelVersion(String modelVersion) {
        if (modelVersion != null && this.version == EntityRecognitionSkillVersion.V1) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("EntityRecognitionSkill using V1 doesn't support 'modelVersion'."));
        }
        if (this.v3Skill != null) {
            this.v3Skill.setModelVersion(modelVersion);
        }
        return this;
    }

    public EntityRecognitionSkill setCategories(EntityCategory ... categories) {
        return this.setCategories(categories == null ? null : Arrays.asList(categories));
    }

    @Override
    public EntityRecognitionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public EntityRecognitionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public EntityRecognitionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.v1Skill != null ? this.v1Skill.toJson(jsonWriter) : this.v3Skill.toJson(jsonWriter);
    }
}

