/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV2;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV2;
import com.azure.search.documents.indexes.models.ClassicTokenizer;
import com.azure.search.documents.indexes.models.EdgeNGramTokenizer;
import com.azure.search.documents.indexes.models.KeywordTokenizer;
import com.azure.search.documents.indexes.models.LuceneStandardTokenizer;
import com.azure.search.documents.indexes.models.MicrosoftLanguageStemmingTokenizer;
import com.azure.search.documents.indexes.models.MicrosoftLanguageTokenizer;
import com.azure.search.documents.indexes.models.NGramTokenizer;
import com.azure.search.documents.indexes.models.PathHierarchyTokenizer;
import com.azure.search.documents.indexes.models.PatternTokenizer;
import com.azure.search.documents.indexes.models.UaxUrlEmailTokenizer;
import java.io.IOException;

public abstract class LexicalTokenizer
implements JsonSerializable<LexicalTokenizer> {
    private final String name;

    public LexicalTokenizer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static LexicalTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (LexicalTokenizer)jsonReader.readObject(reader -> {
            LexicalTokenizer codegen;
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("#Microsoft.Azure.Search.ClassicTokenizer".equals(discriminatorValue)) {
                return ClassicTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.EdgeNGramTokenizer".equals(discriminatorValue)) {
                return EdgeNGramTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.KeywordTokenizerV2".equals(discriminatorValue)) {
                codegen = KeywordTokenizerV2.fromJson(readerToUse);
                return codegen == null ? null : new KeywordTokenizer((KeywordTokenizerV2)codegen);
            }
            if ("#Microsoft.Azure.Search.MicrosoftLanguageTokenizer".equals(discriminatorValue)) {
                return MicrosoftLanguageTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer".equals(discriminatorValue)) {
                return MicrosoftLanguageStemmingTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.NGramTokenizer".equals(discriminatorValue)) {
                return NGramTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.PatternTokenizer".equals(discriminatorValue)) {
                return PatternTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.StandardTokenizerV2".equals(discriminatorValue)) {
                codegen = LuceneStandardTokenizerV2.fromJson(readerToUse);
                return codegen == null ? null : new LuceneStandardTokenizer((LuceneStandardTokenizerV2)codegen);
            }
            if ("#Microsoft.Azure.Search.UaxUrlEmailTokenizer".equals(discriminatorValue)) {
                return UaxUrlEmailTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.PathHierarchyTokenizerV2".equals(discriminatorValue)) {
                return PathHierarchyTokenizer.fromJson(readerToUse);
            }
            if ("#Microsoft.Azure.Search.StandardTokenizer".equals(discriminatorValue)) {
                codegen = LuceneStandardTokenizerV1.fromJson(readerToUse);
                return codegen == null ? null : new LuceneStandardTokenizer((LuceneStandardTokenizerV1)codegen);
            }
            if ("#Microsoft.Azure.Search.KeywordTokenizer".equals(discriminatorValue)) {
                codegen = KeywordTokenizerV1.fromJson(readerToUse);
                return codegen == null ? null : new KeywordTokenizer((KeywordTokenizerV1)codegen);
            }
            throw new IllegalStateException("Discriminator field '@odata.type' didn't match one of the expected values '#Microsoft.Azure.Search.ClassicTokenizer', '#Microsoft.Azure.Search.EdgeNGramTokenizer', '#Microsoft.Azure.Search.KeywordTokenizerV2', '#Microsoft.Azure.Search.MicrosoftLanguageTokenizer', '#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer', '#Microsoft.Azure.Search.NGramTokenizer', '#Microsoft.Azure.Search.PatternTokenizer', '#Microsoft.Azure.Search.StandardTokenizerV2', '#Microsoft.Azure.Search.UaxUrlEmailTokenizer', '#Microsoft.Azure.Search.PathHierarchyTokenizerV2', '#Microsoft.Azure.Search.StandardTokenizer', or '#Microsoft.Azure.Search.KeywordTokenizer'. It was: '" + discriminatorValue + "'.");
        });
    }
}

