/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CharFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MappingCharFilter
extends CharFilter {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.MappingCharFilter";
    private final List<String> mappings;

    public MappingCharFilter(String name, List<String> mappings) {
        super(name);
        this.mappings = mappings;
    }

    public List<String> getMappings() {
        return this.mappings;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("mappings", this.mappings, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MappingCharFilter fromJson(JsonReader jsonReader) throws IOException {
        return (MappingCharFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean mappingsFound = false;
            List mappings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.MappingCharFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("mappings".equals(fieldName)) {
                    mappings = reader.readArray(reader1 -> reader1.getString());
                    mappingsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && mappingsFound) {
                MappingCharFilter deserializedMappingCharFilter = new MappingCharFilter(name, mappings);
                return deserializedMappingCharFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!mappingsFound) {
                missingProperties.add("mappings");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

