/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SearchAlias
implements JsonSerializable<SearchAlias> {
    private final String name;
    private final List<String> indexes;
    private String eTag;

    public SearchAlias(String name, List<String> indexes) {
        this.name = name;
        this.indexes = indexes;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIndexes() {
        return this.indexes;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchAlias setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("indexes", this.indexes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        return jsonWriter.writeEndObject();
    }

    public static SearchAlias fromJson(JsonReader jsonReader) throws IOException {
        return (SearchAlias)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean indexesFound = false;
            List indexes = null;
            String eTag = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("indexes".equals(fieldName)) {
                    indexes = reader.readArray(reader1 -> reader1.getString());
                    indexesFound = true;
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && indexesFound) {
                SearchAlias deserializedSearchAlias = new SearchAlias(name, indexes);
                deserializedSearchAlias.eTag = eTag;
                return deserializedSearchAlias;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!indexesFound) {
                missingProperties.add("indexes");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

