/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.LexicalNormalizerName;
import com.azure.search.documents.indexes.models.SearchFieldDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class SearchField
implements JsonSerializable<SearchField> {
    private final String name;
    private final SearchFieldDataType type;
    private Boolean key;
    private Boolean hidden;
    private Boolean searchable;
    private Boolean filterable;
    private Boolean sortable;
    private Boolean facetable;
    private LexicalAnalyzerName analyzerName;
    private LexicalAnalyzerName searchAnalyzerName;
    private LexicalAnalyzerName indexAnalyzerName;
    private LexicalNormalizerName normalizerName;
    private List<String> synonymMapNames;
    private List<SearchField> fields;

    public SearchField(String name, SearchFieldDataType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public SearchFieldDataType getType() {
        return this.type;
    }

    public Boolean isKey() {
        return this.key;
    }

    public SearchField setKey(Boolean key) {
        this.key = key;
        return this;
    }

    public Boolean isHidden() {
        return this.hidden == null ? null : Boolean.valueOf(this.hidden == false);
    }

    public SearchField setHidden(Boolean hidden) {
        this.hidden = hidden == null ? null : Boolean.valueOf(hidden == false);
        return this;
    }

    public Boolean isSearchable() {
        return this.searchable;
    }

    public SearchField setSearchable(Boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public Boolean isFilterable() {
        return this.filterable;
    }

    public SearchField setFilterable(Boolean filterable) {
        this.filterable = filterable;
        return this;
    }

    public Boolean isSortable() {
        return this.sortable;
    }

    public SearchField setSortable(Boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public Boolean isFacetable() {
        return this.facetable;
    }

    public SearchField setFacetable(Boolean facetable) {
        this.facetable = facetable;
        return this;
    }

    public LexicalAnalyzerName getAnalyzerName() {
        return this.analyzerName;
    }

    public SearchField setAnalyzerName(LexicalAnalyzerName analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public LexicalAnalyzerName getSearchAnalyzerName() {
        return this.searchAnalyzerName;
    }

    public SearchField setSearchAnalyzerName(LexicalAnalyzerName searchAnalyzerName) {
        this.searchAnalyzerName = searchAnalyzerName;
        return this;
    }

    public LexicalAnalyzerName getIndexAnalyzerName() {
        return this.indexAnalyzerName;
    }

    public SearchField setIndexAnalyzerName(LexicalAnalyzerName indexAnalyzerName) {
        this.indexAnalyzerName = indexAnalyzerName;
        return this;
    }

    public LexicalNormalizerName getNormalizerName() {
        return this.normalizerName;
    }

    public SearchField setNormalizerName(LexicalNormalizerName normalizerName) {
        this.normalizerName = normalizerName;
        return this;
    }

    public List<String> getSynonymMapNames() {
        return this.synonymMapNames;
    }

    public SearchField setSynonymMapNames(List<String> synonymMapNames) {
        this.synonymMapNames = synonymMapNames;
        return this;
    }

    public List<SearchField> getFields() {
        return this.fields;
    }

    public SearchField setFields(List<SearchField> fields) {
        this.fields = fields;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", Objects.toString((Object)this.type, null));
        jsonWriter.writeBooleanField("key", this.key);
        jsonWriter.writeBooleanField("retrievable", this.hidden);
        jsonWriter.writeBooleanField("searchable", this.searchable);
        jsonWriter.writeBooleanField("filterable", this.filterable);
        jsonWriter.writeBooleanField("sortable", this.sortable);
        jsonWriter.writeBooleanField("facetable", this.facetable);
        jsonWriter.writeStringField("analyzer", Objects.toString((Object)this.analyzerName, null));
        jsonWriter.writeStringField("searchAnalyzer", Objects.toString((Object)this.searchAnalyzerName, null));
        jsonWriter.writeStringField("indexAnalyzer", Objects.toString((Object)this.indexAnalyzerName, null));
        jsonWriter.writeStringField("normalizer", Objects.toString((Object)this.normalizerName, null));
        jsonWriter.writeArrayField("synonymMaps", this.synonymMapNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fields", this.fields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SearchField fromJson(JsonReader jsonReader) throws IOException {
        return (SearchField)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean typeFound = false;
            SearchFieldDataType type = null;
            Boolean key = null;
            Boolean hidden = null;
            Boolean searchable = null;
            Boolean filterable = null;
            Boolean sortable = null;
            Boolean facetable = null;
            LexicalAnalyzerName analyzerName = null;
            LexicalAnalyzerName searchAnalyzerName = null;
            LexicalAnalyzerName indexAnalyzerName = null;
            LexicalNormalizerName normalizerName = null;
            List synonymMapNames = null;
            List fields = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = SearchFieldDataType.fromString(reader.getString());
                    typeFound = true;
                    continue;
                }
                if ("key".equals(fieldName)) {
                    key = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("retrievable".equals(fieldName)) {
                    hidden = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("searchable".equals(fieldName)) {
                    searchable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("filterable".equals(fieldName)) {
                    filterable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sortable".equals(fieldName)) {
                    sortable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("facetable".equals(fieldName)) {
                    facetable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("analyzer".equals(fieldName)) {
                    analyzerName = LexicalAnalyzerName.fromString(reader.getString());
                    continue;
                }
                if ("searchAnalyzer".equals(fieldName)) {
                    searchAnalyzerName = LexicalAnalyzerName.fromString(reader.getString());
                    continue;
                }
                if ("indexAnalyzer".equals(fieldName)) {
                    indexAnalyzerName = LexicalAnalyzerName.fromString(reader.getString());
                    continue;
                }
                if ("normalizer".equals(fieldName)) {
                    normalizerName = LexicalNormalizerName.fromString(reader.getString());
                    continue;
                }
                if ("synonymMaps".equals(fieldName)) {
                    synonymMapNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    fields = reader.readArray(reader1 -> SearchField.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && typeFound) {
                SearchField deserializedSearchField = new SearchField(name, type);
                deserializedSearchField.key = key;
                deserializedSearchField.hidden = hidden;
                deserializedSearchField.searchable = searchable;
                deserializedSearchField.filterable = filterable;
                deserializedSearchField.sortable = sortable;
                deserializedSearchField.facetable = facetable;
                deserializedSearchField.analyzerName = analyzerName;
                deserializedSearchField.searchAnalyzerName = searchAnalyzerName;
                deserializedSearchField.indexAnalyzerName = indexAnalyzerName;
                deserializedSearchField.normalizerName = normalizerName;
                deserializedSearchField.synonymMapNames = synonymMapNames;
                deserializedSearchField.fields = fields;
                return deserializedSearchField;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!typeFound) {
                missingProperties.add("type");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public SearchField setFields(SearchField ... fields) {
        this.fields = fields == null ? null : Arrays.asList(fields);
        return this;
    }

    public SearchField setSynonymMapNames(String ... synonymMapNames) {
        this.synonymMapNames = synonymMapNames == null ? null : Arrays.asList(synonymMapNames);
        return this;
    }
}

