/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchIndexStatistics
implements JsonSerializable<SearchIndexStatistics> {
    private final long documentCount;
    private final long storageSize;

    public SearchIndexStatistics(long documentCount, long storageSize) {
        this.documentCount = documentCount;
        this.storageSize = storageSize;
    }

    public long getDocumentCount() {
        return this.documentCount;
    }

    public long getStorageSize() {
        return this.storageSize;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("documentCount", this.documentCount);
        jsonWriter.writeLongField("storageSize", this.storageSize);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexStatistics)jsonReader.readObject(reader -> {
            boolean documentCountFound = false;
            long documentCount = 0L;
            boolean storageSizeFound = false;
            long storageSize = 0L;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("documentCount".equals(fieldName)) {
                    documentCount = reader.getLong();
                    documentCountFound = true;
                    continue;
                }
                if ("storageSize".equals(fieldName)) {
                    storageSize = reader.getLong();
                    storageSizeFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (documentCountFound && storageSizeFound) {
                SearchIndexStatistics deserializedSearchIndexStatistics = new SearchIndexStatistics(documentCount, storageSize);
                return deserializedSearchIndexStatistics;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!documentCountFound) {
                missingProperties.add("documentCount");
            }
            if (!storageSizeFound) {
                missingProperties.add("storageSize");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

