/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkillV1;
import com.azure.search.documents.indexes.implementation.models.EntityRecognitionSkillV3;
import com.azure.search.documents.indexes.implementation.models.SentimentSkillV1;
import com.azure.search.documents.indexes.implementation.models.SentimentSkillV3;
import com.azure.search.documents.indexes.models.AzureMachineLearningSkill;
import com.azure.search.documents.indexes.models.ConditionalSkill;
import com.azure.search.documents.indexes.models.CustomEntityLookupSkill;
import com.azure.search.documents.indexes.models.DocumentExtractionSkill;
import com.azure.search.documents.indexes.models.EntityLinkingSkill;
import com.azure.search.documents.indexes.models.EntityRecognitionSkill;
import com.azure.search.documents.indexes.models.ImageAnalysisSkill;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.KeyPhraseExtractionSkill;
import com.azure.search.documents.indexes.models.LanguageDetectionSkill;
import com.azure.search.documents.indexes.models.MergeSkill;
import com.azure.search.documents.indexes.models.OcrSkill;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.PiiDetectionSkill;
import com.azure.search.documents.indexes.models.SentimentSkill;
import com.azure.search.documents.indexes.models.ShaperSkill;
import com.azure.search.documents.indexes.models.SplitSkill;
import com.azure.search.documents.indexes.models.TextTranslationSkill;
import com.azure.search.documents.indexes.models.WebApiSkill;
import java.io.IOException;
import java.util.List;

public abstract class SearchIndexerSkill
implements JsonSerializable<SearchIndexerSkill> {
    private String name;
    private String description;
    private String context;
    private final List<InputFieldMappingEntry> inputs;
    private final List<OutputFieldMappingEntry> outputs;

    public SearchIndexerSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public String getName() {
        return this.name;
    }

    public SearchIndexerSkill setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchIndexerSkill setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getContext() {
        return this.context;
    }

    public SearchIndexerSkill setContext(String context) {
        this.context = context;
        return this;
    }

    public List<InputFieldMappingEntry> getInputs() {
        return this.inputs;
    }

    public List<OutputFieldMappingEntry> getOutputs() {
        return this.outputs;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.inputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("context", this.context);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerSkill fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerSkill)jsonReader.readObject(reader -> {
            SearchIndexerSkill codegen;
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("#Microsoft.Skills.Util.ConditionalSkill".equals(discriminatorValue)) {
                return ConditionalSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.KeyPhraseExtractionSkill".equals(discriminatorValue)) {
                return KeyPhraseExtractionSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Vision.OcrSkill".equals(discriminatorValue)) {
                return OcrSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Vision.ImageAnalysisSkill".equals(discriminatorValue)) {
                return ImageAnalysisSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.LanguageDetectionSkill".equals(discriminatorValue)) {
                return LanguageDetectionSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Util.ShaperSkill".equals(discriminatorValue)) {
                return ShaperSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.MergeSkill".equals(discriminatorValue)) {
                return MergeSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.V3.SentimentSkill".equals(discriminatorValue)) {
                codegen = SentimentSkillV3.fromJson(readerToUse);
                return codegen == null ? null : new SentimentSkill((SentimentSkillV3)codegen);
            }
            if ("#Microsoft.Skills.Text.V3.EntityLinkingSkill".equals(discriminatorValue)) {
                return EntityLinkingSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.V3.EntityRecognitionSkill".equals(discriminatorValue)) {
                codegen = EntityRecognitionSkillV3.fromJson(readerToUse);
                return codegen == null ? null : new EntityRecognitionSkill((EntityRecognitionSkillV3)codegen);
            }
            if ("#Microsoft.Skills.Text.SplitSkill".equals(discriminatorValue)) {
                return SplitSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.CustomEntityLookupSkill".equals(discriminatorValue)) {
                return CustomEntityLookupSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.TranslationSkill".equals(discriminatorValue)) {
                return TextTranslationSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Util.DocumentExtractionSkill".equals(discriminatorValue)) {
                return DocumentExtractionSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Custom.WebApiSkill".equals(discriminatorValue)) {
                return WebApiSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Custom.AmlSkill".equals(discriminatorValue)) {
                return AzureMachineLearningSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.PIIDetectionSkill".equals(discriminatorValue)) {
                return PiiDetectionSkill.fromJson(readerToUse);
            }
            if ("#Microsoft.Skills.Text.EntityRecognitionSkill".equals(discriminatorValue)) {
                codegen = EntityRecognitionSkillV1.fromJson(readerToUse);
                return codegen == null ? null : new EntityRecognitionSkill((EntityRecognitionSkillV1)codegen);
            }
            if ("#Microsoft.Skills.Text.SentimentSkill".equals(discriminatorValue)) {
                codegen = SentimentSkillV1.fromJson(readerToUse);
                return codegen == null ? null : new SentimentSkill((SentimentSkillV1)codegen);
            }
            throw new IllegalStateException("Discriminator field '@odata.type' didn't match one of the expected values '#Microsoft.Skills.Util.ConditionalSkill', '#Microsoft.Skills.Text.KeyPhraseExtractionSkill', '#Microsoft.Skills.Vision.OcrSkill', '#Microsoft.Skills.Vision.ImageAnalysisSkill', '#Microsoft.Skills.Text.LanguageDetectionSkill', '#Microsoft.Skills.Util.ShaperSkill', '#Microsoft.Skills.Text.MergeSkill', '#Microsoft.Skills.Text.V3.SentimentSkill', '#Microsoft.Skills.Text.V3.EntityLinkingSkill', '#Microsoft.Skills.Text.V3.EntityRecognitionSkill', '#Microsoft.Skills.Text.SplitSkill', '#Microsoft.Skills.Text.CustomEntityLookupSkill', '#Microsoft.Skills.Text.TranslationSkill', '#Microsoft.Skills.Util.DocumentExtractionSkill', '#Microsoft.Skills.Custom.WebApiSkill', '#Microsoft.Skills.Custom.AmlSkill', '#Microsoft.Skills.Text.PIIDetectionSkill', '#Microsoft.Skills.Text.EntityRecognitionSkill', or '#Microsoft.Skills.Text.SentimentSkill'. It was: '" + discriminatorValue + "'.");
        });
    }
}

