/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ResourceCounter;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchServiceCounters
implements JsonSerializable<SearchServiceCounters> {
    private ResourceCounter aliasCounter;
    private final ResourceCounter documentCounter;
    private final ResourceCounter indexCounter;
    private final ResourceCounter indexerCounter;
    private final ResourceCounter dataSourceCounter;
    private final ResourceCounter storageSizeCounter;
    private final ResourceCounter synonymMapCounter;
    private ResourceCounter skillsetCounter;

    public SearchServiceCounters(ResourceCounter documentCounter, ResourceCounter indexCounter, ResourceCounter indexerCounter, ResourceCounter dataSourceCounter, ResourceCounter storageSizeCounter, ResourceCounter synonymMapCounter) {
        this.documentCounter = documentCounter;
        this.indexCounter = indexCounter;
        this.indexerCounter = indexerCounter;
        this.dataSourceCounter = dataSourceCounter;
        this.storageSizeCounter = storageSizeCounter;
        this.synonymMapCounter = synonymMapCounter;
    }

    public ResourceCounter getAliasCounter() {
        return this.aliasCounter;
    }

    public SearchServiceCounters setAliasCounter(ResourceCounter aliasCounter) {
        this.aliasCounter = aliasCounter;
        return this;
    }

    public ResourceCounter getDocumentCounter() {
        return this.documentCounter;
    }

    public ResourceCounter getIndexCounter() {
        return this.indexCounter;
    }

    public ResourceCounter getIndexerCounter() {
        return this.indexerCounter;
    }

    public ResourceCounter getDataSourceCounter() {
        return this.dataSourceCounter;
    }

    public ResourceCounter getStorageSizeCounter() {
        return this.storageSizeCounter;
    }

    public ResourceCounter getSynonymMapCounter() {
        return this.synonymMapCounter;
    }

    public ResourceCounter getSkillsetCounter() {
        return this.skillsetCounter;
    }

    public SearchServiceCounters setSkillsetCounter(ResourceCounter skillsetCounter) {
        this.skillsetCounter = skillsetCounter;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("documentCount", (JsonSerializable)this.documentCounter);
        jsonWriter.writeJsonField("indexesCount", (JsonSerializable)this.indexCounter);
        jsonWriter.writeJsonField("indexersCount", (JsonSerializable)this.indexerCounter);
        jsonWriter.writeJsonField("dataSourcesCount", (JsonSerializable)this.dataSourceCounter);
        jsonWriter.writeJsonField("storageSize", (JsonSerializable)this.storageSizeCounter);
        jsonWriter.writeJsonField("synonymMaps", (JsonSerializable)this.synonymMapCounter);
        jsonWriter.writeJsonField("aliasesCount", (JsonSerializable)this.aliasCounter);
        jsonWriter.writeJsonField("skillsetCount", (JsonSerializable)this.skillsetCounter);
        return jsonWriter.writeEndObject();
    }

    public static SearchServiceCounters fromJson(JsonReader jsonReader) throws IOException {
        return (SearchServiceCounters)jsonReader.readObject(reader -> {
            boolean documentCounterFound = false;
            ResourceCounter documentCounter = null;
            boolean indexCounterFound = false;
            ResourceCounter indexCounter = null;
            boolean indexerCounterFound = false;
            ResourceCounter indexerCounter = null;
            boolean dataSourceCounterFound = false;
            ResourceCounter dataSourceCounter = null;
            boolean storageSizeCounterFound = false;
            ResourceCounter storageSizeCounter = null;
            boolean synonymMapCounterFound = false;
            ResourceCounter synonymMapCounter = null;
            ResourceCounter aliasCounter = null;
            ResourceCounter skillsetCounter = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("documentCount".equals(fieldName)) {
                    documentCounter = ResourceCounter.fromJson(reader);
                    documentCounterFound = true;
                    continue;
                }
                if ("indexesCount".equals(fieldName)) {
                    indexCounter = ResourceCounter.fromJson(reader);
                    indexCounterFound = true;
                    continue;
                }
                if ("indexersCount".equals(fieldName)) {
                    indexerCounter = ResourceCounter.fromJson(reader);
                    indexerCounterFound = true;
                    continue;
                }
                if ("dataSourcesCount".equals(fieldName)) {
                    dataSourceCounter = ResourceCounter.fromJson(reader);
                    dataSourceCounterFound = true;
                    continue;
                }
                if ("storageSize".equals(fieldName)) {
                    storageSizeCounter = ResourceCounter.fromJson(reader);
                    storageSizeCounterFound = true;
                    continue;
                }
                if ("synonymMaps".equals(fieldName)) {
                    synonymMapCounter = ResourceCounter.fromJson(reader);
                    synonymMapCounterFound = true;
                    continue;
                }
                if ("aliasesCount".equals(fieldName)) {
                    aliasCounter = ResourceCounter.fromJson(reader);
                    continue;
                }
                if ("skillsetCount".equals(fieldName)) {
                    skillsetCounter = ResourceCounter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (documentCounterFound && indexCounterFound && indexerCounterFound && dataSourceCounterFound && storageSizeCounterFound && synonymMapCounterFound) {
                SearchServiceCounters deserializedSearchServiceCounters = new SearchServiceCounters(documentCounter, indexCounter, indexerCounter, dataSourceCounter, storageSizeCounter, synonymMapCounter);
                deserializedSearchServiceCounters.aliasCounter = aliasCounter;
                deserializedSearchServiceCounters.skillsetCounter = skillsetCounter;
                return deserializedSearchServiceCounters;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!documentCounterFound) {
                missingProperties.add("documentCount");
            }
            if (!indexCounterFound) {
                missingProperties.add("indexesCount");
            }
            if (!indexerCounterFound) {
                missingProperties.add("indexersCount");
            }
            if (!dataSourceCounterFound) {
                missingProperties.add("dataSourcesCount");
            }
            if (!storageSizeCounterFound) {
                missingProperties.add("storageSize");
            }
            if (!synonymMapCounterFound) {
                missingProperties.add("synonymMaps");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

