/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.implementation.converters.SearchResultHelper;
import com.azure.search.documents.models.CaptionResult;
import java.util.List;
import java.util.Map;

public final class SearchResult {
    private final double score;
    private Double rerankerScore;
    private Map<String, List<String>> highlights;
    private List<CaptionResult> captions;
    private Map<String, Object> additionalProperties;
    private JsonSerializer jsonSerializer;

    public SearchResult(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public Double getRerankerScore() {
        return this.rerankerScore;
    }

    public Map<String, List<String>> getHighlights() {
        return this.highlights;
    }

    public List<CaptionResult> getCaptions() {
        return this.captions;
    }

    public <T> T getDocument(Class<T> modelClass) {
        return (T)this.jsonSerializer.deserializeFromBytes(this.jsonSerializer.serializeToBytes(this.additionalProperties), TypeReference.createInstance(modelClass));
    }

    private void setAdditionalProperties(SearchDocument additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    private void setHighlights(Map<String, List<String>> highlights) {
        this.highlights = highlights;
    }

    private void setJsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    private void setRerankerScore(Double rerankerScore) {
        this.rerankerScore = rerankerScore;
    }

    private void setCaptions(List<CaptionResult> captions) {
        this.captions = captions;
    }

    static {
        SearchResultHelper.setAccessor(new SearchResultHelper.SearchResultAccessor(){

            @Override
            public void setAdditionalProperties(SearchResult searchResult, SearchDocument additionalProperties) {
                searchResult.setAdditionalProperties(additionalProperties);
            }

            @Override
            public void setHighlights(SearchResult searchResult, Map<String, List<String>> highlights) {
                searchResult.setHighlights(highlights);
            }

            @Override
            public void setJsonSerializer(SearchResult searchResult, JsonSerializer jsonSerializer) {
                searchResult.setJsonSerializer(jsonSerializer);
            }

            @Override
            public void setRerankerScore(SearchResult searchResult, Double rerankerScore) {
                searchResult.setRerankerScore(rerankerScore);
            }

            @Override
            public void setCaptions(SearchResult searchResult, List<CaptionResult> captions) {
                searchResult.setCaptions(captions);
            }
        });
    }
}

