/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SearchResult;
import com.azure.search.documents.models.AnswerResult;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.SemanticPartialResponseReason;
import com.azure.search.documents.models.SemanticPartialResponseType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SearchDocumentsResult
implements JsonSerializable<SearchDocumentsResult> {
    private Long count;
    private Double coverage;
    private Map<String, List<FacetResult>> facets;
    private List<AnswerResult> answers;
    private SearchRequest nextPageParameters;
    private SemanticPartialResponseReason semanticPartialResponseReason;
    private SemanticPartialResponseType semanticPartialResponseType;
    private final List<SearchResult> results;
    private String nextLink;

    public SearchDocumentsResult(List<SearchResult> results) {
        this.results = results;
    }

    public Long getCount() {
        return this.count;
    }

    public Double getCoverage() {
        return this.coverage;
    }

    public Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    public List<AnswerResult> getAnswers() {
        return this.answers;
    }

    public SearchRequest getNextPageParameters() {
        return this.nextPageParameters;
    }

    public SemanticPartialResponseReason getSemanticPartialResponseReason() {
        return this.semanticPartialResponseReason;
    }

    public SemanticPartialResponseType getSemanticPartialResponseType() {
        return this.semanticPartialResponseType;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.results, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("@odata.count", (Number)this.count);
        jsonWriter.writeNumberField("@search.coverage", (Number)this.coverage);
        jsonWriter.writeMapField("@search.facets", this.facets, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        jsonWriter.writeArrayField("@search.answers", this.answers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("@search.nextPageParameters", (JsonSerializable)this.nextPageParameters);
        jsonWriter.writeStringField("@search.semanticPartialResponseReason", Objects.toString((Object)this.semanticPartialResponseReason, null));
        jsonWriter.writeStringField("@search.semanticPartialResponseType", Objects.toString((Object)this.semanticPartialResponseType, null));
        jsonWriter.writeStringField("@odata.nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SearchDocumentsResult fromJson(JsonReader jsonReader) throws IOException {
        return (SearchDocumentsResult)jsonReader.readObject(reader -> {
            boolean resultsFound = false;
            List results = null;
            Long count = null;
            Double coverage = null;
            Map facets = null;
            List answers = null;
            SearchRequest nextPageParameters = null;
            SemanticPartialResponseReason semanticPartialResponseReason = null;
            SemanticPartialResponseType semanticPartialResponseType = null;
            String nextLink = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    results = reader.readArray(reader1 -> SearchResult.fromJson(reader1));
                    resultsFound = true;
                    continue;
                }
                if ("@odata.count".equals(fieldName)) {
                    count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("@search.coverage".equals(fieldName)) {
                    coverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("@search.facets".equals(fieldName)) {
                    facets = reader.readMap(reader1 -> reader1.readArray(reader2 -> FacetResult.fromJson(reader2)));
                    continue;
                }
                if ("@search.answers".equals(fieldName)) {
                    answers = reader.readArray(reader1 -> AnswerResult.fromJson(reader1));
                    continue;
                }
                if ("@search.nextPageParameters".equals(fieldName)) {
                    nextPageParameters = SearchRequest.fromJson(reader);
                    continue;
                }
                if ("@search.semanticPartialResponseReason".equals(fieldName)) {
                    semanticPartialResponseReason = SemanticPartialResponseReason.fromString(reader.getString());
                    continue;
                }
                if ("@search.semanticPartialResponseType".equals(fieldName)) {
                    semanticPartialResponseType = SemanticPartialResponseType.fromString(reader.getString());
                    continue;
                }
                if ("@odata.nextLink".equals(fieldName)) {
                    nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (resultsFound) {
                SearchDocumentsResult deserializedSearchDocumentsResult = new SearchDocumentsResult(results);
                deserializedSearchDocumentsResult.count = count;
                deserializedSearchDocumentsResult.coverage = coverage;
                deserializedSearchDocumentsResult.facets = facets;
                deserializedSearchDocumentsResult.answers = answers;
                deserializedSearchDocumentsResult.nextPageParameters = nextPageParameters;
                deserializedSearchDocumentsResult.semanticPartialResponseReason = semanticPartialResponseReason;
                deserializedSearchDocumentsResult.semanticPartialResponseType = semanticPartialResponseType;
                deserializedSearchDocumentsResult.nextLink = nextLink;
                return deserializedSearchDocumentsResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!resultsFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

