/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class AsciiFoldingTokenFilter
extends TokenFilter {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.AsciiFoldingTokenFilter";
    private Boolean preserveOriginal;

    public AsciiFoldingTokenFilter(String name) {
        super(name);
    }

    public Boolean isPreserveOriginal() {
        return this.preserveOriginal;
    }

    public AsciiFoldingTokenFilter setPreserveOriginal(Boolean preserveOriginal) {
        this.preserveOriginal = preserveOriginal;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeBooleanField("preserveOriginal", this.preserveOriginal);
        return jsonWriter.writeEndObject();
    }

    public static AsciiFoldingTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (AsciiFoldingTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Boolean preserveOriginal = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.AsciiFoldingTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("preserveOriginal".equals(fieldName)) {
                    preserveOriginal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                AsciiFoldingTokenFilter deserializedAsciiFoldingTokenFilter = new AsciiFoldingTokenFilter(name);
                deserializedAsciiFoldingTokenFilter.preserveOriginal = preserveOriginal;
                return deserializedAsciiFoldingTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

