/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CommonGramTokenFilter
extends TokenFilter {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.CommonGramTokenFilter";
    private final List<String> commonWords;
    private Boolean caseIgnored;
    private Boolean queryModeUsed;

    public CommonGramTokenFilter(String name, List<String> commonWords) {
        super(name);
        this.commonWords = commonWords;
    }

    public List<String> getCommonWords() {
        return this.commonWords;
    }

    public Boolean isCaseIgnored() {
        return this.caseIgnored;
    }

    public CommonGramTokenFilter setCaseIgnored(Boolean caseIgnored) {
        this.caseIgnored = caseIgnored;
        return this;
    }

    public Boolean isQueryModeUsed() {
        return this.queryModeUsed;
    }

    public CommonGramTokenFilter setQueryModeUsed(Boolean queryModeUsed) {
        this.queryModeUsed = queryModeUsed;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("commonWords", this.commonWords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("ignoreCase", this.caseIgnored);
        jsonWriter.writeBooleanField("queryMode", this.queryModeUsed);
        return jsonWriter.writeEndObject();
    }

    public static CommonGramTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (CommonGramTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean commonWordsFound = false;
            List commonWords = null;
            Boolean caseIgnored = null;
            Boolean queryModeUsed = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.CommonGramTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("commonWords".equals(fieldName)) {
                    commonWords = reader.readArray(reader1 -> reader1.getString());
                    commonWordsFound = true;
                    continue;
                }
                if ("ignoreCase".equals(fieldName)) {
                    caseIgnored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("queryMode".equals(fieldName)) {
                    queryModeUsed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && commonWordsFound) {
                CommonGramTokenFilter deserializedCommonGramTokenFilter = new CommonGramTokenFilter(name, commonWords);
                deserializedCommonGramTokenFilter.caseIgnored = caseIgnored;
                deserializedCommonGramTokenFilter.queryModeUsed = queryModeUsed;
                return deserializedCommonGramTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!commonWordsFound) {
                missingProperties.add("commonWords");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

