/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class CustomAnalyzer
extends LexicalAnalyzer {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.CustomAnalyzer";
    private final LexicalTokenizerName tokenizer;
    private List<TokenFilterName> tokenFilters;
    private List<CharFilterName> charFilters;

    public CustomAnalyzer(String name, LexicalTokenizerName tokenizer) {
        super(name);
        this.tokenizer = tokenizer;
    }

    public LexicalTokenizerName getTokenizer() {
        return this.tokenizer;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    public CustomAnalyzer setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    public CustomAnalyzer setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("tokenizer", Objects.toString((Object)this.tokenizer, null));
        jsonWriter.writeArrayField("tokenFilters", this.tokenFilters, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeArrayField("charFilters", this.charFilters, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        return jsonWriter.writeEndObject();
    }

    public static CustomAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return (CustomAnalyzer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean tokenizerFound = false;
            LexicalTokenizerName tokenizer = null;
            List tokenFilters = null;
            List charFilters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.CustomAnalyzer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("tokenizer".equals(fieldName)) {
                    tokenizer = LexicalTokenizerName.fromString(reader.getString());
                    tokenizerFound = true;
                    continue;
                }
                if ("tokenFilters".equals(fieldName)) {
                    tokenFilters = reader.readArray(reader1 -> TokenFilterName.fromString(reader1.getString()));
                    continue;
                }
                if ("charFilters".equals(fieldName)) {
                    charFilters = reader.readArray(reader1 -> CharFilterName.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && tokenizerFound) {
                CustomAnalyzer deserializedCustomAnalyzer = new CustomAnalyzer(name, tokenizer);
                deserializedCustomAnalyzer.tokenFilters = tokenFilters;
                deserializedCustomAnalyzer.charFilters = charFilters;
                return deserializedCustomAnalyzer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!tokenizerFound) {
                missingProperties.add("tokenizer");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public CustomAnalyzer setTokenFilters(TokenFilterName ... tokenFilters) {
        this.tokenFilters = tokenFilters == null ? null : Arrays.asList(tokenFilters);
        return this;
    }

    public CustomAnalyzer setCharFilters(CharFilterName ... charFilters) {
        this.charFilters = charFilters == null ? null : Arrays.asList(charFilters);
        return this;
    }
}

