/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.HnswParameters;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmConfiguration;
import java.io.IOException;
import java.util.ArrayList;

public final class HnswVectorSearchAlgorithmConfiguration
extends VectorSearchAlgorithmConfiguration {
    private static final String KIND = "hnsw";
    private HnswParameters parameters;

    public HnswVectorSearchAlgorithmConfiguration(String name) {
        super(name);
    }

    public HnswParameters getParameters() {
        return this.parameters;
    }

    public HnswVectorSearchAlgorithmConfiguration setParameters(HnswParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", KIND);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeJsonField("hnswParameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static HnswVectorSearchAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (HnswVectorSearchAlgorithmConfiguration)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            HnswParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if (KIND.equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'hnsw'. The found 'kind' was '" + kind + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("hnswParameters".equals(fieldName)) {
                    parameters = HnswParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                HnswVectorSearchAlgorithmConfiguration deserializedHnswVectorSearchAlgorithmConfiguration = new HnswVectorSearchAlgorithmConfiguration(name);
                deserializedHnswVectorSearchAlgorithmConfiguration.parameters = parameters;
                return deserializedHnswVectorSearchAlgorithmConfiguration;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

