/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ImageAnalysisSkillLanguage;
import com.azure.search.documents.indexes.models.ImageDetail;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.VisualFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ImageAnalysisSkill
extends SearchIndexerSkill {
    private static final String ODATA_TYPE = "#Microsoft.Skills.Vision.ImageAnalysisSkill";
    private ImageAnalysisSkillLanguage defaultLanguageCode;
    private List<VisualFeature> visualFeatures;
    private List<ImageDetail> details;

    public ImageAnalysisSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public ImageAnalysisSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public ImageAnalysisSkill setDefaultLanguageCode(ImageAnalysisSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public List<VisualFeature> getVisualFeatures() {
        return this.visualFeatures;
    }

    public ImageAnalysisSkill setVisualFeatures(List<VisualFeature> visualFeatures) {
        this.visualFeatures = visualFeatures;
        return this;
    }

    public List<ImageDetail> getDetails() {
        return this.details;
    }

    public ImageAnalysisSkill setDetails(List<ImageDetail> details) {
        this.details = details;
        return this;
    }

    @Override
    public ImageAnalysisSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ImageAnalysisSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ImageAnalysisSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultLanguageCode", Objects.toString((Object)this.defaultLanguageCode, null));
        jsonWriter.writeArrayField("visualFeatures", this.visualFeatures, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        return jsonWriter.writeEndObject();
    }

    public static ImageAnalysisSkill fromJson(JsonReader jsonReader) throws IOException {
        return (ImageAnalysisSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            ImageAnalysisSkillLanguage defaultLanguageCode = null;
            List visualFeatures = null;
            List details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Vision.ImageAnalysisSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = ImageAnalysisSkillLanguage.fromString(reader.getString());
                    continue;
                }
                if ("visualFeatures".equals(fieldName)) {
                    visualFeatures = reader.readArray(reader1 -> VisualFeature.fromString(reader1.getString()));
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ImageDetail.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                ImageAnalysisSkill deserializedImageAnalysisSkill = new ImageAnalysisSkill(inputs, outputs);
                deserializedImageAnalysisSkill.setName(name);
                deserializedImageAnalysisSkill.setDescription(description);
                deserializedImageAnalysisSkill.setContext(context);
                deserializedImageAnalysisSkill.defaultLanguageCode = defaultLanguageCode;
                deserializedImageAnalysisSkill.visualFeatures = visualFeatures;
                deserializedImageAnalysisSkill.details = details;
                return deserializedImageAnalysisSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public ImageAnalysisSkill setVisualFeatures(VisualFeature ... visualFeatures) {
        this.visualFeatures = visualFeatures == null ? null : Arrays.asList(visualFeatures);
        return this;
    }

    public ImageAnalysisSkill setDetails(ImageDetail ... details) {
        this.details = details == null ? null : Arrays.asList(details);
        return this;
    }
}

