/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import com.azure.search.documents.indexes.models.MicrosoftTokenizerLanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class MicrosoftLanguageTokenizer
extends LexicalTokenizer {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.MicrosoftLanguageTokenizer";
    private Integer maxTokenLength;
    private Boolean isSearchTokenizer;
    private MicrosoftTokenizerLanguage language;

    public MicrosoftLanguageTokenizer(String name) {
        super(name);
    }

    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public MicrosoftLanguageTokenizer setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    public Boolean isSearchTokenizer() {
        return this.isSearchTokenizer;
    }

    public MicrosoftLanguageTokenizer setIsSearchTokenizer(Boolean isSearchTokenizer) {
        this.isSearchTokenizer = isSearchTokenizer;
        return this;
    }

    public MicrosoftTokenizerLanguage getLanguage() {
        return this.language;
    }

    public MicrosoftLanguageTokenizer setLanguage(MicrosoftTokenizerLanguage language) {
        this.language = language;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("maxTokenLength", (Number)this.maxTokenLength);
        jsonWriter.writeBooleanField("isSearchTokenizer", this.isSearchTokenizer);
        jsonWriter.writeStringField("language", Objects.toString((Object)this.language, null));
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftLanguageTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftLanguageTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer maxTokenLength = null;
            Boolean isSearchTokenizer = null;
            MicrosoftTokenizerLanguage language = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.MicrosoftLanguageTokenizer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isSearchTokenizer".equals(fieldName)) {
                    isSearchTokenizer = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("language".equals(fieldName)) {
                    language = MicrosoftTokenizerLanguage.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                MicrosoftLanguageTokenizer deserializedMicrosoftLanguageTokenizer = new MicrosoftLanguageTokenizer(name);
                deserializedMicrosoftLanguageTokenizer.maxTokenLength = maxTokenLength;
                deserializedMicrosoftLanguageTokenizer.isSearchTokenizer = isSearchTokenizer;
                deserializedMicrosoftLanguageTokenizer.language = language;
                return deserializedMicrosoftLanguageTokenizer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

