/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.models.RegexFlags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class PatternAnalyzer
extends LexicalAnalyzer {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.PatternAnalyzer";
    private Boolean lowerCaseTerms;
    private String pattern;
    private RegexFlags flags;
    private List<String> stopwords;

    public PatternAnalyzer(String name) {
        super(name);
    }

    public Boolean areLowerCaseTerms() {
        return this.lowerCaseTerms;
    }

    public PatternAnalyzer setLowerCaseTerms(Boolean lowerCaseTerms) {
        this.lowerCaseTerms = lowerCaseTerms;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PatternAnalyzer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public List<RegexFlags> getFlags() {
        if (this.flags == null) {
            return null;
        }
        String[] flagStrings = this.flags.toString().split("\\|");
        return Arrays.stream(flagStrings).map(RegexFlags::fromString).collect(Collectors.toList());
    }

    public PatternAnalyzer setFlags(List<RegexFlags> flags) {
        if (flags == null) {
            this.flags = null;
        } else {
            String flagString = flags.stream().map(ExpandableStringEnum::toString).collect(Collectors.joining("|"));
            this.flags = RegexFlags.fromString(flagString);
        }
        return this;
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public PatternAnalyzer setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeBooleanField("lowercase", this.lowerCaseTerms);
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("flags", Objects.toString((Object)this.flags, null));
        jsonWriter.writeArrayField("stopwords", this.stopwords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PatternAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return (PatternAnalyzer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Boolean lowerCaseTerms = null;
            String pattern = null;
            RegexFlags flags = null;
            List stopwords = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PatternAnalyzer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("lowercase".equals(fieldName)) {
                    lowerCaseTerms = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("pattern".equals(fieldName)) {
                    pattern = reader.getString();
                    continue;
                }
                if ("flags".equals(fieldName)) {
                    flags = RegexFlags.fromString(reader.getString());
                    continue;
                }
                if ("stopwords".equals(fieldName)) {
                    stopwords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                PatternAnalyzer deserializedPatternAnalyzer = new PatternAnalyzer(name);
                deserializedPatternAnalyzer.lowerCaseTerms = lowerCaseTerms;
                deserializedPatternAnalyzer.pattern = pattern;
                deserializedPatternAnalyzer.flags = flags;
                deserializedPatternAnalyzer.stopwords = stopwords;
                return deserializedPatternAnalyzer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public PatternAnalyzer setStopwords(String ... stopwords) {
        this.stopwords = stopwords == null ? null : Arrays.asList(stopwords);
        return this;
    }

    public PatternAnalyzer setFlags(RegexFlags ... flags) {
        if (flags == null) {
            this.flags = null;
            return this;
        }
        return this.setFlags(Arrays.asList(flags));
    }
}

