/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchIndexerError
implements JsonSerializable<SearchIndexerError> {
    private String key;
    private final String errorMessage;
    private final int statusCode;
    private String name;
    private String details;
    private String documentationLink;

    public SearchIndexerError(String errorMessage, int statusCode) {
        this.errorMessage = errorMessage;
        this.statusCode = statusCode;
    }

    public String getKey() {
        return this.key;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getName() {
        return this.name;
    }

    public String getDetails() {
        return this.details;
    }

    public String getDocumentationLink() {
        return this.documentationLink;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeIntField("statusCode", this.statusCode);
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("details", this.details);
        jsonWriter.writeStringField("documentationLink", this.documentationLink);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerError fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerError)jsonReader.readObject(reader -> {
            boolean errorMessageFound = false;
            String errorMessage = null;
            boolean statusCodeFound = false;
            int statusCode = 0;
            String key = null;
            String name = null;
            String details = null;
            String documentationLink = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorMessage".equals(fieldName)) {
                    errorMessage = reader.getString();
                    errorMessageFound = true;
                    continue;
                }
                if ("statusCode".equals(fieldName)) {
                    statusCode = reader.getInt();
                    statusCodeFound = true;
                    continue;
                }
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.getString();
                    continue;
                }
                if ("documentationLink".equals(fieldName)) {
                    documentationLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (errorMessageFound && statusCodeFound) {
                SearchIndexerError deserializedSearchIndexerError = new SearchIndexerError(errorMessage, statusCode);
                deserializedSearchIndexerError.key = key;
                deserializedSearchIndexerError.name = name;
                deserializedSearchIndexerError.details = details;
                deserializedSearchIndexerError.documentationLink = documentationLink;
                return deserializedSearchIndexerError;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!errorMessageFound) {
                missingProperties.add("errorMessage");
            }
            if (!statusCodeFound) {
                missingProperties.add("statusCode");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

