/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.IndexerExecutionResult;
import com.azure.search.documents.indexes.models.IndexerStatus;
import com.azure.search.documents.indexes.models.SearchIndexerLimits;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class SearchIndexerStatus
implements JsonSerializable<SearchIndexerStatus> {
    private final IndexerStatus status;
    private IndexerExecutionResult lastResult;
    private final List<IndexerExecutionResult> executionHistory;
    private final SearchIndexerLimits limits;

    public SearchIndexerStatus(IndexerStatus status, List<IndexerExecutionResult> executionHistory, SearchIndexerLimits limits) {
        this.status = status;
        this.executionHistory = executionHistory;
        this.limits = limits;
    }

    public IndexerStatus getStatus() {
        return this.status;
    }

    public IndexerExecutionResult getLastResult() {
        return this.lastResult;
    }

    public List<IndexerExecutionResult> getExecutionHistory() {
        return this.executionHistory;
    }

    public SearchIndexerLimits getLimits() {
        return this.limits;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", Objects.toString((Object)this.status, null));
        jsonWriter.writeArrayField("executionHistory", this.executionHistory, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("limits", (JsonSerializable)this.limits);
        jsonWriter.writeJsonField("lastResult", (JsonSerializable)this.lastResult);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerStatus fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerStatus)jsonReader.readObject(reader -> {
            boolean statusFound = false;
            IndexerStatus status = null;
            boolean executionHistoryFound = false;
            List executionHistory = null;
            boolean limitsFound = false;
            SearchIndexerLimits limits = null;
            IndexerExecutionResult lastResult = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = IndexerStatus.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("executionHistory".equals(fieldName)) {
                    executionHistory = reader.readArray(reader1 -> IndexerExecutionResult.fromJson(reader1));
                    executionHistoryFound = true;
                    continue;
                }
                if ("limits".equals(fieldName)) {
                    limits = SearchIndexerLimits.fromJson(reader);
                    limitsFound = true;
                    continue;
                }
                if ("lastResult".equals(fieldName)) {
                    lastResult = IndexerExecutionResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (statusFound && executionHistoryFound && limitsFound) {
                SearchIndexerStatus deserializedSearchIndexerStatus = new SearchIndexerStatus(status, executionHistory, limits);
                deserializedSearchIndexerStatus.lastResult = lastResult;
                return deserializedSearchIndexerStatus;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!statusFound) {
                missingProperties.add("status");
            }
            if (!executionHistoryFound) {
                missingProperties.add("executionHistory");
            }
            if (!limitsFound) {
                missingProperties.add("limits");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

