/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchIndexerWarning
implements JsonSerializable<SearchIndexerWarning> {
    private String key;
    private final String message;
    private String name;
    private String details;
    private String documentationLink;

    public SearchIndexerWarning(String message) {
        this.message = message;
    }

    public String getKey() {
        return this.key;
    }

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.name;
    }

    public String getDetails() {
        return this.details;
    }

    public String getDocumentationLink() {
        return this.documentationLink;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("details", this.details);
        jsonWriter.writeStringField("documentationLink", this.documentationLink);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerWarning fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerWarning)jsonReader.readObject(reader -> {
            boolean messageFound = false;
            String message = null;
            String key = null;
            String name = null;
            String details = null;
            String documentationLink = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.getString();
                    continue;
                }
                if ("documentationLink".equals(fieldName)) {
                    documentationLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (messageFound) {
                SearchIndexerWarning deserializedSearchIndexerWarning = new SearchIndexerWarning(message);
                deserializedSearchIndexerWarning.key = key;
                deserializedSearchIndexerWarning.name = name;
                deserializedSearchIndexerWarning.details = details;
                deserializedSearchIndexerWarning.documentationLink = documentationLink;
                return deserializedSearchIndexerWarning;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!messageFound) {
                missingProperties.add("message");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

