/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SearchSuggester
implements JsonSerializable<SearchSuggester> {
    private final String name;
    private String searchMode = "analyzingInfixMatching";
    private final List<String> sourceFields;

    public SearchSuggester(String name, List<String> sourceFields) {
        this.name = name;
        this.sourceFields = sourceFields;
    }

    public String getName() {
        return this.name;
    }

    public String getSearchMode() {
        return this.searchMode;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("sourceFields", this.sourceFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("searchMode", this.searchMode);
        return jsonWriter.writeEndObject();
    }

    public static SearchSuggester fromJson(JsonReader jsonReader) throws IOException {
        return (SearchSuggester)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean sourceFieldsFound = false;
            List sourceFields = null;
            String searchMode = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("sourceFields".equals(fieldName)) {
                    sourceFields = reader.readArray(reader1 -> reader1.getString());
                    sourceFieldsFound = true;
                    continue;
                }
                if ("searchMode".equals(fieldName)) {
                    searchMode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && sourceFieldsFound) {
                SearchSuggester deserializedSearchSuggester = new SearchSuggester(name, sourceFields);
                deserializedSearchSuggester.searchMode = searchMode;
                return deserializedSearchSuggester;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!sourceFieldsFound) {
                missingProperties.add("sourceFields");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

