/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class TruncateTokenFilter
extends TokenFilter {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.TruncateTokenFilter";
    private Integer length;

    public TruncateTokenFilter(String name) {
        super(name);
    }

    public Integer getLength() {
        return this.length;
    }

    public TruncateTokenFilter setLength(Integer length) {
        this.length = length;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("length", (Number)this.length);
        return jsonWriter.writeEndObject();
    }

    public static TruncateTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (TruncateTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer length = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.TruncateTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("length".equals(fieldName)) {
                    length = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                TruncateTokenFilter deserializedTruncateTokenFilter = new TruncateTokenFilter(name);
                deserializedTruncateTokenFilter.length = length;
                return deserializedTruncateTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

