/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.AutocompleteItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AutocompleteResult
implements JsonSerializable<AutocompleteResult> {
    private Double coverage;
    private final List<AutocompleteItem> results;

    public AutocompleteResult(List<AutocompleteItem> results) {
        this.results = results;
    }

    public Double getCoverage() {
        return this.coverage;
    }

    public List<AutocompleteItem> getResults() {
        return this.results;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.results, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("@search.coverage", (Number)this.coverage);
        return jsonWriter.writeEndObject();
    }

    public static AutocompleteResult fromJson(JsonReader jsonReader) throws IOException {
        return (AutocompleteResult)jsonReader.readObject(reader -> {
            boolean resultsFound = false;
            List results = null;
            Double coverage = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    results = reader.readArray(reader1 -> AutocompleteItem.fromJson(reader1));
                    resultsFound = true;
                    continue;
                }
                if ("@search.coverage".equals(fieldName)) {
                    coverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            if (resultsFound) {
                AutocompleteResult deserializedAutocompleteResult = new AutocompleteResult(results);
                deserializedAutocompleteResult.coverage = coverage;
                return deserializedAutocompleteResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!resultsFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

