/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.util;

import com.azure.core.http.rest.PagedFluxBase;
import com.azure.search.documents.implementation.models.SearchFirstPageResponseWrapper;
import com.azure.search.documents.models.AnswerResult;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.SearchResult;
import com.azure.search.documents.models.SemanticPartialResponseReason;
import com.azure.search.documents.models.SemanticPartialResponseType;
import com.azure.search.documents.util.SearchPagedResponse;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public final class SearchPagedFlux
extends PagedFluxBase<SearchResult, SearchPagedResponse> {
    private final Supplier<Mono<SearchFirstPageResponseWrapper>> metadataSupplier = () -> ((Mono)firstPageRetriever.get()).map(response -> new SearchFirstPageResponseWrapper().setFirstPageResponse((SearchPagedResponse)((Object)((Object)response))));

    public SearchPagedFlux(Supplier<Mono<SearchPagedResponse>> firstPageRetriever) {
        super(firstPageRetriever);
    }

    public SearchPagedFlux(Supplier<Mono<SearchPagedResponse>> firstPageRetriever, Function<String, Mono<SearchPagedResponse>> nextPageRetriever) {
        super(firstPageRetriever, nextPageRetriever);
    }

    public Mono<Long> getTotalCount() {
        return this.metadataSupplier.get().flatMap(metaData -> {
            if (metaData.getFirstPageResponse().getCount() == null) {
                return Mono.empty();
            }
            return Mono.just((Object)metaData.getFirstPageResponse().getCount());
        });
    }

    public Mono<Double> getCoverage() {
        return this.metadataSupplier.get().flatMap(metaData -> {
            if (metaData.getFirstPageResponse().getCoverage() == null) {
                return Mono.empty();
            }
            return Mono.just((Object)metaData.getFirstPageResponse().getCoverage());
        });
    }

    public Mono<Map<String, List<FacetResult>>> getFacets() {
        return this.metadataSupplier.get().flatMap(metaData -> {
            if (metaData.getFirstPageResponse().getFacets() == null) {
                return Mono.empty();
            }
            return Mono.just(metaData.getFirstPageResponse().getFacets());
        });
    }

    public Mono<List<AnswerResult>> getAnswers() {
        return this.metadataSupplier.get().flatMap(metaData -> {
            if (metaData.getFirstPageResponse().getAnswers() == null) {
                return Mono.empty();
            }
            return Mono.just(metaData.getFirstPageResponse().getAnswers());
        });
    }

    public Mono<SemanticPartialResponseReason> getSemanticPartialResponseReason() {
        return this.metadataSupplier.get().flatMap(metaData -> {
            if (metaData.getFirstPageResponse().getSemanticPartialResponseReason() == null) {
                return Mono.empty();
            }
            return Mono.just((Object)((Object)metaData.getFirstPageResponse().getSemanticPartialResponseReason()));
        });
    }

    public Mono<SemanticPartialResponseType> getSemanticPartialResponseType() {
        return this.metadataSupplier.get().flatMap(metaData -> {
            if (metaData.getFirstPageResponse().getSemanticPartialResponseType() == null) {
                return Mono.empty();
            }
            return Mono.just((Object)((Object)metaData.getFirstPageResponse().getSemanticPartialResponseType()));
        });
    }
}

