/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.util;

import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.search.documents.implementation.util.SearchPagedResponseAccessHelper;
import com.azure.search.documents.models.AnswerResult;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.SearchResult;
import com.azure.search.documents.models.SemanticPartialResponseReason;
import com.azure.search.documents.models.SemanticPartialResponseType;
import java.util.List;
import java.util.Map;

public final class SearchPagedResponse
extends PagedResponseBase<Void, SearchResult> {
    private final List<SearchResult> value;
    private final Long count;
    private final Double coverage;
    private final Map<String, List<FacetResult>> facets;
    private final List<AnswerResult> answers;
    private final SemanticPartialResponseReason semanticPartialResponseReason;
    private final SemanticPartialResponseType semanticPartialResponseType;

    public SearchPagedResponse(Response<List<SearchResult>> response, String continuationToken, Map<String, List<FacetResult>> facets, Long count, Double coverage) {
        this(response, continuationToken, facets, count, coverage, null, null, null);
    }

    public SearchPagedResponse(Response<List<SearchResult>> response, String continuationToken, Map<String, List<FacetResult>> facets, Long count, Double coverage, List<AnswerResult> answers, SemanticPartialResponseReason semanticPartialResponseReason, SemanticPartialResponseType semanticPartialResponseType) {
        super(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), continuationToken, null);
        this.value = (List)response.getValue();
        this.facets = facets;
        this.count = count;
        this.coverage = coverage;
        this.answers = answers;
        this.semanticPartialResponseReason = semanticPartialResponseReason;
        this.semanticPartialResponseType = semanticPartialResponseType;
    }

    Double getCoverage() {
        return this.coverage;
    }

    Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    Long getCount() {
        return this.count;
    }

    List<AnswerResult> getAnswers() {
        return this.answers;
    }

    SemanticPartialResponseReason getSemanticPartialResponseReason() {
        return this.semanticPartialResponseReason;
    }

    SemanticPartialResponseType getSemanticPartialResponseType() {
        return this.semanticPartialResponseType;
    }

    public List<SearchResult> getValue() {
        return this.value;
    }

    static {
        SearchPagedResponseAccessHelper.setAccessor(new SearchPagedResponseAccessHelper.SearchPagedResponseAccessor(){

            @Override
            public Double getCoverage(SearchPagedResponse response) {
                return response.getCoverage();
            }

            @Override
            public Map<String, List<FacetResult>> getFacets(SearchPagedResponse response) {
                return response.getFacets();
            }

            @Override
            public Long getCount(SearchPagedResponse response) {
                return response.getCount();
            }

            @Override
            public List<AnswerResult> getAnswers(SearchPagedResponse response) {
                return response.getAnswers();
            }

            @Override
            public SemanticPartialResponseReason getSemanticPartialResponseReason(SearchPagedResponse response) {
                return response.getSemanticPartialResponseReason();
            }

            @Override
            public SemanticPartialResponseType getSemanticPartialResponseType(SearchPagedResponse response) {
                return response.getSemanticPartialResponseType();
            }
        });
    }
}

