/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ListDataSourcesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class DataSourcesImpl {
    private final DataSourcesService service;
    private final SearchServiceClientImpl client;

    DataSourcesImpl(SearchServiceClientImpl client) {
        this.service = (DataSourcesService)RestProxy.create(DataSourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> createOrUpdateWithResponseAsync(String dataSourceName, SearchIndexerDataSourceConnection dataSource, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, RequestOptions requestOptions) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), skipIndexerResetRequirementForCache, "application/json; odata.metadata=minimal", dataSource, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> createOrUpdateWithResponseAsync(String dataSourceName, SearchIndexerDataSourceConnection dataSource, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), skipIndexerResetRequirementForCache, "application/json; odata.metadata=minimal", dataSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> createOrUpdateAsync(String dataSourceName, SearchIndexerDataSourceConnection dataSource, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, RequestOptions requestOptions) {
        return this.createOrUpdateWithResponseAsync(dataSourceName, dataSource, ifMatch, ifNoneMatch, skipIndexerResetRequirementForCache, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerDataSourceConnection)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> createOrUpdateAsync(String dataSourceName, SearchIndexerDataSourceConnection dataSource, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, RequestOptions requestOptions, Context context) {
        return this.createOrUpdateWithResponseAsync(dataSourceName, dataSource, ifMatch, ifNoneMatch, skipIndexerResetRequirementForCache, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerDataSourceConnection)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> createOrUpdateWithResponse(String dataSourceName, SearchIndexerDataSourceConnection dataSource, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdateSync(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), skipIndexerResetRequirementForCache, "application/json; odata.metadata=minimal", dataSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection createOrUpdate(String dataSourceName, SearchIndexerDataSourceConnection dataSource, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, RequestOptions requestOptions) {
        return (SearchIndexerDataSourceConnection)this.createOrUpdateWithResponse(dataSourceName, dataSource, ifMatch, ifNoneMatch, skipIndexerResetRequirementForCache, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String dataSourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String dataSourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String dataSourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.deleteWithResponseAsync(dataSourceName, ifMatch, ifNoneMatch, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String dataSourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.deleteWithResponseAsync(dataSourceName, ifMatch, ifNoneMatch, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String dataSourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.deleteSync(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String dataSourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        this.deleteWithResponse(dataSourceName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> getWithResponseAsync(String dataSourceName, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> getWithResponseAsync(String dataSourceName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> getAsync(String dataSourceName, RequestOptions requestOptions) {
        return this.getWithResponseAsync(dataSourceName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerDataSourceConnection)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> getAsync(String dataSourceName, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(dataSourceName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerDataSourceConnection)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> getWithResponse(String dataSourceName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getSync(this.client.getEndpoint(), dataSourceName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection get(String dataSourceName, RequestOptions requestOptions) {
        return (SearchIndexerDataSourceConnection)this.getWithResponse(dataSourceName, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListDataSourcesResult>> listWithResponseAsync(String select, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListDataSourcesResult>> listWithResponseAsync(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListDataSourcesResult> listAsync(String select, RequestOptions requestOptions) {
        return this.listWithResponseAsync(select, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((ListDataSourcesResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListDataSourcesResult> listAsync(String select, RequestOptions requestOptions, Context context) {
        return this.listWithResponseAsync(select, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((ListDataSourcesResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListDataSourcesResult> listWithResponse(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.listSync(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListDataSourcesResult list(String select, RequestOptions requestOptions) {
        return (ListDataSourcesResult)this.listWithResponse(select, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> createWithResponseAsync(SearchIndexerDataSourceConnection dataSource, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", dataSource, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> createWithResponseAsync(SearchIndexerDataSourceConnection dataSource, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", dataSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> createAsync(SearchIndexerDataSourceConnection dataSource, RequestOptions requestOptions) {
        return this.createWithResponseAsync(dataSource, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerDataSourceConnection)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> createAsync(SearchIndexerDataSourceConnection dataSource, RequestOptions requestOptions, Context context) {
        return this.createWithResponseAsync(dataSource, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerDataSourceConnection)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> createWithResponse(SearchIndexerDataSourceConnection dataSource, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", dataSource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection create(SearchIndexerDataSourceConnection dataSource, RequestOptions requestOptions) {
        return (SearchIndexerDataSourceConnection)this.createWithResponse(dataSource, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientD")
    public static interface DataSourcesService {
        @Put(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndexerDataSourceConnection>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="ignoreResetRequirements") Boolean var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") SearchIndexerDataSourceConnection var10, Context var11);

        @Put(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Response<SearchIndexerDataSourceConnection> createOrUpdateSync(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="ignoreResetRequirements") Boolean var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") SearchIndexerDataSourceConnection var10, Context var11);

        @Delete(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndexerDataSourceConnection>> get(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/datasources('{dataSourceName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Response<SearchIndexerDataSourceConnection> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="dataSourceName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/datasources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<ListDataSourcesResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/datasources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Response<ListDataSourcesResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/datasources")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndexerDataSourceConnection>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchIndexerDataSourceConnection var5, Context var6);

        @Post(value="/datasources")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Response<SearchIndexerDataSourceConnection> createSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchIndexerDataSourceConnection var5, Context var6);
    }
}

