/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.SentimentSkillLanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class SentimentSkillV1
extends SearchIndexerSkill {
    private static final String ODATA_TYPE = "#Microsoft.Skills.Text.SentimentSkill";
    private SentimentSkillLanguage defaultLanguageCode;

    public SentimentSkillV1(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public SentimentSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public SentimentSkillV1 setDefaultLanguageCode(SentimentSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    @Override
    public SentimentSkillV1 setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SentimentSkillV1 setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SentimentSkillV1 setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultLanguageCode", Objects.toString((Object)this.defaultLanguageCode, null));
        return jsonWriter.writeEndObject();
    }

    public static SentimentSkillV1 fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentSkillV1)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            SentimentSkillLanguage defaultLanguageCode = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.SentimentSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = SentimentSkillLanguage.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                SentimentSkillV1 deserializedSentimentSkillV1 = new SentimentSkillV1(inputs, outputs);
                deserializedSentimentSkillV1.setName(name);
                deserializedSentimentSkillV1.setDescription(description);
                deserializedSentimentSkillV1.setContext(context);
                deserializedSentimentSkillV1.defaultLanguageCode = defaultLanguageCode;
                return deserializedSentimentSkillV1;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

