/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CognitiveServicesAccount;
import java.io.IOException;
import java.util.ArrayList;

public final class CognitiveServicesAccountKey
extends CognitiveServicesAccount {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.CognitiveServicesByKey";
    private String key;

    public CognitiveServicesAccountKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public CognitiveServicesAccountKey setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    public static CognitiveServicesAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return (CognitiveServicesAccountKey)jsonReader.readObject(reader -> {
            String description = null;
            boolean keyFound = false;
            String key = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.CognitiveServicesByKey'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (keyFound) {
                CognitiveServicesAccountKey deserializedCognitiveServicesAccountKey = new CognitiveServicesAccountKey(key);
                deserializedCognitiveServicesAccountKey.setDescription(description);
                return deserializedCognitiveServicesAccountKey;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!keyFound) {
                missingProperties.add("key");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public CognitiveServicesAccountKey setKey(String key) {
        this.key = key;
        return this;
    }
}

