/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class EntityLinkingSkill
extends SearchIndexerSkill {
    private static final String ODATA_TYPE = "#Microsoft.Skills.Text.V3.EntityLinkingSkill";
    private String defaultLanguageCode;
    private Double minimumPrecision;
    private String modelVersion;

    public EntityLinkingSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public EntityLinkingSkill setDefaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Double getMinimumPrecision() {
        return this.minimumPrecision;
    }

    public EntityLinkingSkill setMinimumPrecision(Double minimumPrecision) {
        this.minimumPrecision = minimumPrecision;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public EntityLinkingSkill setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    @Override
    public EntityLinkingSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public EntityLinkingSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public EntityLinkingSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultLanguageCode", this.defaultLanguageCode);
        jsonWriter.writeNumberField("minimumPrecision", (Number)this.minimumPrecision);
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        return jsonWriter.writeEndObject();
    }

    public static EntityLinkingSkill fromJson(JsonReader jsonReader) throws IOException {
        return (EntityLinkingSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String defaultLanguageCode = null;
            Double minimumPrecision = null;
            String modelVersion = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.V3.EntityLinkingSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = reader.getString();
                    continue;
                }
                if ("minimumPrecision".equals(fieldName)) {
                    minimumPrecision = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                EntityLinkingSkill deserializedEntityLinkingSkill = new EntityLinkingSkill(inputs, outputs);
                deserializedEntityLinkingSkill.setName(name);
                deserializedEntityLinkingSkill.setDescription(description);
                deserializedEntityLinkingSkill.setContext(context);
                deserializedEntityLinkingSkill.defaultLanguageCode = defaultLanguageCode;
                deserializedEntityLinkingSkill.minimumPrecision = minimumPrecision;
                deserializedEntityLinkingSkill.modelVersion = modelVersion;
                return deserializedEntityLinkingSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

