/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class LengthTokenFilter
extends TokenFilter {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.LengthTokenFilter";
    private Integer minLength;
    private Integer maxLength;

    public LengthTokenFilter(String name) {
        super(name);
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public LengthTokenFilter setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public LengthTokenFilter setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("min", (Number)this.minLength);
        jsonWriter.writeNumberField("max", (Number)this.maxLength);
        return jsonWriter.writeEndObject();
    }

    public static LengthTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (LengthTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer minLength = null;
            Integer maxLength = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.LengthTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("min".equals(fieldName)) {
                    minLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max".equals(fieldName)) {
                    maxLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LengthTokenFilter deserializedLengthTokenFilter = new LengthTokenFilter(name);
                deserializedLengthTokenFilter.minLength = minLength;
                deserializedLengthTokenFilter.maxLength = maxLength;
                return deserializedLengthTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

