/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LuceneStandardAnalyzer
extends LexicalAnalyzer {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.StandardAnalyzer";
    private Integer maxTokenLength;
    private List<String> stopwords;

    public LuceneStandardAnalyzer(String name) {
        super(name);
    }

    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public LuceneStandardAnalyzer setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public LuceneStandardAnalyzer setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("maxTokenLength", (Number)this.maxTokenLength);
        jsonWriter.writeArrayField("stopwords", this.stopwords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static LuceneStandardAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return (LuceneStandardAnalyzer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer maxTokenLength = null;
            List stopwords = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.StandardAnalyzer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("stopwords".equals(fieldName)) {
                    stopwords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LuceneStandardAnalyzer deserializedLuceneStandardAnalyzer = new LuceneStandardAnalyzer(name);
                deserializedLuceneStandardAnalyzer.maxTokenLength = maxTokenLength;
                deserializedLuceneStandardAnalyzer.stopwords = stopwords;
                return deserializedLuceneStandardAnalyzer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public LuceneStandardAnalyzer setStopwords(String ... stopwords) {
        this.stopwords = stopwords == null ? null : Arrays.asList(stopwords);
        return this;
    }
}

