/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.PiiDetectionSkillMaskingMode;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class PiiDetectionSkill
extends SearchIndexerSkill {
    private static final String ODATA_TYPE = "#Microsoft.Skills.Text.PIIDetectionSkill";
    private String defaultLanguageCode;
    private Double minimumPrecision;
    private PiiDetectionSkillMaskingMode maskingMode;
    private String maskingCharacter;
    private String modelVersion;
    private List<String> piiCategories;
    private String domain;

    public PiiDetectionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public PiiDetectionSkill setDefaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Double getMinimumPrecision() {
        return this.minimumPrecision;
    }

    public PiiDetectionSkill setMinimumPrecision(Double minimumPrecision) {
        this.minimumPrecision = minimumPrecision;
        return this;
    }

    public PiiDetectionSkillMaskingMode getMaskingMode() {
        return this.maskingMode;
    }

    public PiiDetectionSkill setMaskingMode(PiiDetectionSkillMaskingMode maskingMode) {
        this.maskingMode = maskingMode;
        return this;
    }

    public String getMaskingCharacter() {
        return this.maskingCharacter;
    }

    public PiiDetectionSkill setMaskingCharacter(String maskingCharacter) {
        this.maskingCharacter = maskingCharacter;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public PiiDetectionSkill setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    public List<String> getPiiCategories() {
        return this.piiCategories;
    }

    public PiiDetectionSkill setPiiCategories(List<String> piiCategories) {
        this.piiCategories = piiCategories;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public PiiDetectionSkill setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public PiiDetectionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public PiiDetectionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public PiiDetectionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultLanguageCode", this.defaultLanguageCode);
        jsonWriter.writeNumberField("minimumPrecision", (Number)this.minimumPrecision);
        jsonWriter.writeStringField("maskingMode", Objects.toString((Object)this.maskingMode, null));
        jsonWriter.writeStringField("maskingCharacter", this.maskingCharacter);
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeArrayField("piiCategories", this.piiCategories, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("domain", this.domain);
        return jsonWriter.writeEndObject();
    }

    public static PiiDetectionSkill fromJson(JsonReader jsonReader) throws IOException {
        return (PiiDetectionSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String defaultLanguageCode = null;
            Double minimumPrecision = null;
            PiiDetectionSkillMaskingMode maskingMode = null;
            String maskingCharacter = null;
            String modelVersion = null;
            List piiCategories = null;
            String domain = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.PIIDetectionSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = reader.getString();
                    continue;
                }
                if ("minimumPrecision".equals(fieldName)) {
                    minimumPrecision = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maskingMode".equals(fieldName)) {
                    maskingMode = PiiDetectionSkillMaskingMode.fromString(reader.getString());
                    continue;
                }
                if ("maskingCharacter".equals(fieldName)) {
                    maskingCharacter = reader.getString();
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    continue;
                }
                if ("piiCategories".equals(fieldName)) {
                    piiCategories = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    domain = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                PiiDetectionSkill deserializedPiiDetectionSkill = new PiiDetectionSkill(inputs, outputs);
                deserializedPiiDetectionSkill.setName(name);
                deserializedPiiDetectionSkill.setDescription(description);
                deserializedPiiDetectionSkill.setContext(context);
                deserializedPiiDetectionSkill.defaultLanguageCode = defaultLanguageCode;
                deserializedPiiDetectionSkill.minimumPrecision = minimumPrecision;
                deserializedPiiDetectionSkill.maskingMode = maskingMode;
                deserializedPiiDetectionSkill.maskingCharacter = maskingCharacter;
                deserializedPiiDetectionSkill.modelVersion = modelVersion;
                deserializedPiiDetectionSkill.piiCategories = piiCategories;
                deserializedPiiDetectionSkill.domain = domain;
                return deserializedPiiDetectionSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

