/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.DistanceScoringFunction;
import com.azure.search.documents.indexes.models.FreshnessScoringFunction;
import com.azure.search.documents.indexes.models.MagnitudeScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionInterpolation;
import com.azure.search.documents.indexes.models.TagScoringFunction;
import java.io.IOException;
import java.util.Objects;

public abstract class ScoringFunction
implements JsonSerializable<ScoringFunction> {
    private final String fieldName;
    private final double boost;
    private ScoringFunctionInterpolation interpolation;

    public ScoringFunction(String fieldName, double boost) {
        this.fieldName = fieldName;
        this.boost = boost;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public double getBoost() {
        return this.boost;
    }

    public ScoringFunctionInterpolation getInterpolation() {
        return this.interpolation;
    }

    public ScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        this.interpolation = interpolation;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.fieldName);
        jsonWriter.writeDoubleField("boost", this.boost);
        jsonWriter.writeStringField("interpolation", Objects.toString((Object)this.interpolation, null));
        return jsonWriter.writeEndObject();
    }

    public static ScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return (ScoringFunction)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("type".equals(jsonFieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("distance".equals(discriminatorValue)) {
                return DistanceScoringFunction.fromJson(readerToUse);
            }
            if ("freshness".equals(discriminatorValue)) {
                return FreshnessScoringFunction.fromJson(readerToUse);
            }
            if ("magnitude".equals(discriminatorValue)) {
                return MagnitudeScoringFunction.fromJson(readerToUse);
            }
            if ("tag".equals(discriminatorValue)) {
                return TagScoringFunction.fromJson(readerToUse);
            }
            throw new IllegalStateException("Discriminator field 'type' didn't match one of the expected values 'distance', 'freshness', 'magnitude', or 'tag'. It was: '" + discriminatorValue + "'.");
        });
    }
}

