/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchIndexerDataUserAssignedIdentity
extends SearchIndexerDataIdentity {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.DataUserAssignedIdentity";
    private final String userAssignedIdentity;

    public SearchIndexerDataUserAssignedIdentity(String userAssignedIdentity) {
        this.userAssignedIdentity = userAssignedIdentity;
    }

    public String getUserAssignedIdentity() {
        return this.userAssignedIdentity;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("userAssignedIdentity", this.userAssignedIdentity);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerDataUserAssignedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerDataUserAssignedIdentity)jsonReader.readObject(reader -> {
            boolean userAssignedIdentityFound = false;
            String userAssignedIdentity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.DataUserAssignedIdentity'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("userAssignedIdentity".equals(fieldName)) {
                    userAssignedIdentity = reader.getString();
                    userAssignedIdentityFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (userAssignedIdentityFound) {
                SearchIndexerDataUserAssignedIdentity deserializedSearchIndexerDataUserAssignedIdentity = new SearchIndexerDataUserAssignedIdentity(userAssignedIdentity);
                return deserializedSearchIndexerDataUserAssignedIdentity;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!userAssignedIdentityFound) {
                missingProperties.add("userAssignedIdentity");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

