/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;

public final class SearchIndexerLimits
implements JsonSerializable<SearchIndexerLimits> {
    private Duration maxRunTime;
    private Long maxDocumentExtractionSize;
    private Long maxDocumentContentCharactersToExtract;

    public Duration getMaxRunTime() {
        return this.maxRunTime;
    }

    public Long getMaxDocumentExtractionSize() {
        return this.maxDocumentExtractionSize;
    }

    public Long getMaxDocumentContentCharactersToExtract() {
        return this.maxDocumentContentCharactersToExtract;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("maxRunTime", Objects.toString(this.maxRunTime, null));
        jsonWriter.writeNumberField("maxDocumentExtractionSize", (Number)this.maxDocumentExtractionSize);
        jsonWriter.writeNumberField("maxDocumentContentCharactersToExtract", (Number)this.maxDocumentContentCharactersToExtract);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerLimits fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerLimits)jsonReader.readObject(reader -> {
            SearchIndexerLimits deserializedSearchIndexerLimits = new SearchIndexerLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxRunTime".equals(fieldName)) {
                    deserializedSearchIndexerLimits.maxRunTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxDocumentExtractionSize".equals(fieldName)) {
                    deserializedSearchIndexerLimits.maxDocumentExtractionSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maxDocumentContentCharactersToExtract".equals(fieldName)) {
                    deserializedSearchIndexerLimits.maxDocumentContentCharactersToExtract = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchIndexerLimits;
        });
    }
}

