/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SemanticConfiguration;
import java.io.IOException;
import java.util.List;

public final class SemanticSettings
implements JsonSerializable<SemanticSettings> {
    private String defaultConfiguration;
    private List<SemanticConfiguration> configurations;

    public String getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public SemanticSettings setDefaultConfiguration(String defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        return this;
    }

    public List<SemanticConfiguration> getConfigurations() {
        return this.configurations;
    }

    public SemanticSettings setConfigurations(List<SemanticConfiguration> configurations) {
        this.configurations = configurations;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultConfiguration", this.defaultConfiguration);
        jsonWriter.writeArrayField("configurations", this.configurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SemanticSettings fromJson(JsonReader jsonReader) throws IOException {
        return (SemanticSettings)jsonReader.readObject(reader -> {
            SemanticSettings deserializedSemanticSettings = new SemanticSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultConfiguration".equals(fieldName)) {
                    deserializedSemanticSettings.defaultConfiguration = reader.getString();
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    List configurations;
                    deserializedSemanticSettings.configurations = configurations = reader.readArray(reader1 -> SemanticConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSemanticSettings;
        });
    }
}

