/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.SentimentSkillV1;
import com.azure.search.documents.indexes.implementation.models.SentimentSkillV3;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.SentimentSkillLanguage;
import com.azure.search.documents.indexes.models.SentimentSkillVersion;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class SentimentSkill
extends SearchIndexerSkill {
    private static final ClientLogger LOGGER = new ClientLogger(SentimentSkill.class);
    private final SentimentSkillVersion version;
    private final SentimentSkillV1 v1Skill;
    private final SentimentSkillV3 v3Skill;

    SentimentSkill(SentimentSkillV1 v1Skill) {
        super(v1Skill.getInputs(), v1Skill.getOutputs());
        this.version = SentimentSkillVersion.V1;
        this.v1Skill = v1Skill;
        this.v3Skill = null;
    }

    SentimentSkill(SentimentSkillV3 v3Skill) {
        super(v3Skill.getInputs(), v3Skill.getOutputs());
        this.version = SentimentSkillVersion.V3;
        this.v1Skill = null;
        this.v3Skill = v3Skill;
    }

    @Deprecated
    public SentimentSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        this(inputs, outputs, SentimentSkillVersion.V1);
    }

    public SentimentSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, SentimentSkillVersion version) {
        super(inputs, outputs);
        this.version = Objects.requireNonNull(version, "'version' cannot be null.");
        if (version == SentimentSkillVersion.V1) {
            this.v1Skill = new SentimentSkillV1(inputs, outputs);
            this.v3Skill = null;
        } else {
            this.v1Skill = null;
            this.v3Skill = new SentimentSkillV3(inputs, outputs);
        }
    }

    public SentimentSkillVersion getSkillVersion() {
        return this.version;
    }

    public SentimentSkillLanguage getDefaultLanguageCode() {
        return this.v1Skill != null ? this.v1Skill.getDefaultLanguageCode() : SentimentSkillLanguage.fromString(this.v3Skill.getDefaultLanguageCode());
    }

    public SentimentSkill setDefaultLanguageCode(SentimentSkillLanguage defaultLanguageCode) {
        if (this.v1Skill != null) {
            this.v1Skill.setDefaultLanguageCode(defaultLanguageCode);
        } else {
            this.v3Skill.setDefaultLanguageCode(defaultLanguageCode == null ? null : defaultLanguageCode.toString());
        }
        return this;
    }

    public Boolean isIncludeOpinionMining() {
        return this.v1Skill != null ? null : this.v3Skill.isIncludeOpinionMining();
    }

    public SentimentSkill setIncludeOpinionMining(Boolean includeOpinionMining) {
        if (includeOpinionMining != null && this.version == SentimentSkillVersion.V1) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("SentimentSkill using V1 doesn't support 'includeOpinionMining'."));
        }
        if (this.v3Skill != null) {
            this.v3Skill.setIncludeOpinionMining(includeOpinionMining);
        }
        return this;
    }

    public String getModelVersion() {
        return this.v1Skill != null ? null : this.v3Skill.getModelVersion();
    }

    public SentimentSkill setModelVersion(String modelVersion) {
        if (modelVersion != null && this.version == SentimentSkillVersion.V1) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("SentimentSkill using V1 doesn't support 'modelVersion'."));
        }
        if (this.v3Skill != null) {
            this.v3Skill.setModelVersion(modelVersion);
        }
        return this;
    }

    @Override
    public SentimentSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SentimentSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SentimentSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.v1Skill != null ? this.v1Skill.toJson(jsonWriter) : this.v3Skill.toJson(jsonWriter);
    }
}

