/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SynonymTokenFilter
extends TokenFilter {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.SynonymTokenFilter";
    private final List<String> synonyms;
    private Boolean caseIgnored;
    private Boolean expand;

    public SynonymTokenFilter(String name, List<String> synonyms) {
        super(name);
        this.synonyms = synonyms;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public Boolean isCaseIgnored() {
        return this.caseIgnored;
    }

    public SynonymTokenFilter setCaseIgnored(Boolean caseIgnored) {
        this.caseIgnored = caseIgnored;
        return this;
    }

    public Boolean getExpand() {
        return this.expand;
    }

    public SynonymTokenFilter setExpand(Boolean expand) {
        this.expand = expand;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("synonyms", this.synonyms, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("ignoreCase", this.caseIgnored);
        jsonWriter.writeBooleanField("expand", this.expand);
        return jsonWriter.writeEndObject();
    }

    public static SynonymTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (SynonymTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean synonymsFound = false;
            List synonyms = null;
            Boolean caseIgnored = null;
            Boolean expand = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.SynonymTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("synonyms".equals(fieldName)) {
                    synonyms = reader.readArray(reader1 -> reader1.getString());
                    synonymsFound = true;
                    continue;
                }
                if ("ignoreCase".equals(fieldName)) {
                    caseIgnored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("expand".equals(fieldName)) {
                    expand = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && synonymsFound) {
                SynonymTokenFilter deserializedSynonymTokenFilter = new SynonymTokenFilter(name, synonyms);
                deserializedSynonymTokenFilter.caseIgnored = caseIgnored;
                deserializedSynonymTokenFilter.expand = expand;
                return deserializedSynonymTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!synonymsFound) {
                missingProperties.add("synonyms");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

