/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class WordDelimiterTokenFilter
extends TokenFilter {
    private static final String ODATA_TYPE = "#Microsoft.Azure.Search.WordDelimiterTokenFilter";
    private Boolean generateWordParts;
    private Boolean generateNumberParts;
    private Boolean wordsCatenated;
    private Boolean numbersCatenated;
    private Boolean catenateAll;
    private Boolean splitOnCaseChange;
    private Boolean preserveOriginal;
    private Boolean splitOnNumerics;
    private Boolean stemEnglishPossessive;
    private List<String> protectedWords;

    public WordDelimiterTokenFilter(String name) {
        super(name);
    }

    public Boolean generateWordParts() {
        return this.generateWordParts;
    }

    public WordDelimiterTokenFilter setGenerateWordParts(Boolean generateWordParts) {
        this.generateWordParts = generateWordParts;
        return this;
    }

    public Boolean generateNumberParts() {
        return this.generateNumberParts;
    }

    public WordDelimiterTokenFilter setGenerateNumberParts(Boolean generateNumberParts) {
        this.generateNumberParts = generateNumberParts;
        return this;
    }

    public Boolean areWordsCatenated() {
        return this.wordsCatenated;
    }

    public WordDelimiterTokenFilter setWordsCatenated(Boolean wordsCatenated) {
        this.wordsCatenated = wordsCatenated;
        return this;
    }

    public Boolean areNumbersCatenated() {
        return this.numbersCatenated;
    }

    public WordDelimiterTokenFilter setNumbersCatenated(Boolean numbersCatenated) {
        this.numbersCatenated = numbersCatenated;
        return this;
    }

    public Boolean catenateAll() {
        return this.catenateAll;
    }

    public WordDelimiterTokenFilter setCatenateAll(Boolean catenateAll) {
        this.catenateAll = catenateAll;
        return this;
    }

    public Boolean splitOnCaseChange() {
        return this.splitOnCaseChange;
    }

    public WordDelimiterTokenFilter setSplitOnCaseChange(Boolean splitOnCaseChange) {
        this.splitOnCaseChange = splitOnCaseChange;
        return this;
    }

    public Boolean isPreserveOriginal() {
        return this.preserveOriginal;
    }

    public WordDelimiterTokenFilter setPreserveOriginal(Boolean preserveOriginal) {
        this.preserveOriginal = preserveOriginal;
        return this;
    }

    public Boolean splitOnNumerics() {
        return this.splitOnNumerics;
    }

    public WordDelimiterTokenFilter setSplitOnNumerics(Boolean splitOnNumerics) {
        this.splitOnNumerics = splitOnNumerics;
        return this;
    }

    public Boolean isStemEnglishPossessive() {
        return this.stemEnglishPossessive;
    }

    public WordDelimiterTokenFilter setStemEnglishPossessive(Boolean stemEnglishPossessive) {
        this.stemEnglishPossessive = stemEnglishPossessive;
        return this;
    }

    public List<String> getProtectedWords() {
        return this.protectedWords;
    }

    public WordDelimiterTokenFilter setProtectedWords(List<String> protectedWords) {
        this.protectedWords = protectedWords;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeBooleanField("generateWordParts", this.generateWordParts);
        jsonWriter.writeBooleanField("generateNumberParts", this.generateNumberParts);
        jsonWriter.writeBooleanField("catenateWords", this.wordsCatenated);
        jsonWriter.writeBooleanField("catenateNumbers", this.numbersCatenated);
        jsonWriter.writeBooleanField("catenateAll", this.catenateAll);
        jsonWriter.writeBooleanField("splitOnCaseChange", this.splitOnCaseChange);
        jsonWriter.writeBooleanField("preserveOriginal", this.preserveOriginal);
        jsonWriter.writeBooleanField("splitOnNumerics", this.splitOnNumerics);
        jsonWriter.writeBooleanField("stemEnglishPossessive", this.stemEnglishPossessive);
        jsonWriter.writeArrayField("protectedWords", this.protectedWords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static WordDelimiterTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (WordDelimiterTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Boolean generateWordParts = null;
            Boolean generateNumberParts = null;
            Boolean wordsCatenated = null;
            Boolean numbersCatenated = null;
            Boolean catenateAll = null;
            Boolean splitOnCaseChange = null;
            Boolean preserveOriginal = null;
            Boolean splitOnNumerics = null;
            Boolean stemEnglishPossessive = null;
            List protectedWords = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.WordDelimiterTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("generateWordParts".equals(fieldName)) {
                    generateWordParts = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("generateNumberParts".equals(fieldName)) {
                    generateNumberParts = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("catenateWords".equals(fieldName)) {
                    wordsCatenated = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("catenateNumbers".equals(fieldName)) {
                    numbersCatenated = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("catenateAll".equals(fieldName)) {
                    catenateAll = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("splitOnCaseChange".equals(fieldName)) {
                    splitOnCaseChange = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("preserveOriginal".equals(fieldName)) {
                    preserveOriginal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("splitOnNumerics".equals(fieldName)) {
                    splitOnNumerics = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stemEnglishPossessive".equals(fieldName)) {
                    stemEnglishPossessive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("protectedWords".equals(fieldName)) {
                    protectedWords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                WordDelimiterTokenFilter deserializedWordDelimiterTokenFilter = new WordDelimiterTokenFilter(name);
                deserializedWordDelimiterTokenFilter.generateWordParts = generateWordParts;
                deserializedWordDelimiterTokenFilter.generateNumberParts = generateNumberParts;
                deserializedWordDelimiterTokenFilter.wordsCatenated = wordsCatenated;
                deserializedWordDelimiterTokenFilter.numbersCatenated = numbersCatenated;
                deserializedWordDelimiterTokenFilter.catenateAll = catenateAll;
                deserializedWordDelimiterTokenFilter.splitOnCaseChange = splitOnCaseChange;
                deserializedWordDelimiterTokenFilter.preserveOriginal = preserveOriginal;
                deserializedWordDelimiterTokenFilter.splitOnNumerics = splitOnNumerics;
                deserializedWordDelimiterTokenFilter.stemEnglishPossessive = stemEnglishPossessive;
                deserializedWordDelimiterTokenFilter.protectedWords = protectedWords;
                return deserializedWordDelimiterTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public WordDelimiterTokenFilter setProtectedWords(String ... protectedWords) {
        this.protectedWords = protectedWords == null ? null : Arrays.asList(protectedWords);
        return this;
    }
}

