/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SearchQueryVector
implements JsonSerializable<SearchQueryVector> {
    private List<Float> value;
    private Integer kNearestNeighborsCount;
    private String fields;

    public List<Float> getValue() {
        return this.value;
    }

    public SearchQueryVector setValue(List<Float> value) {
        this.value = value;
        return this;
    }

    public Integer getKNearestNeighborsCount() {
        return this.kNearestNeighborsCount;
    }

    public SearchQueryVector setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        this.kNearestNeighborsCount = kNearestNeighborsCount;
        return this;
    }

    public String getFields() {
        return this.fields;
    }

    public SearchQueryVector setFields(String ... fields) {
        this.fields = String.join((CharSequence)",", fields);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeFloat(element.floatValue()));
        jsonWriter.writeNumberField("k", (Number)this.kNearestNeighborsCount);
        jsonWriter.writeStringField("fields", this.fields);
        return jsonWriter.writeEndObject();
    }

    public static SearchQueryVector fromJson(JsonReader jsonReader) throws IOException {
        return (SearchQueryVector)jsonReader.readObject(reader -> {
            SearchQueryVector deserializedSearchQueryVector = new SearchQueryVector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSearchQueryVector.value = value = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                if ("k".equals(fieldName)) {
                    deserializedSearchQueryVector.kNearestNeighborsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    deserializedSearchQueryVector.fields = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchQueryVector;
        });
    }
}

