// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.search.documents.indexes.implementation.models.AnalyzeRequest;
import com.azure.search.documents.indexes.implementation.models.AnalyzeResult;
import com.azure.search.documents.indexes.implementation.models.ListIndexesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexStatistics;
import java.util.UUID;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Indexes. */
public final class IndexesImpl {
    /** The proxy service used to perform REST calls. */
    private final IndexesService service;

    /** The service client containing this operation class. */
    private final SearchServiceClientImpl client;

    /**
     * Initializes an instance of IndexesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    IndexesImpl(SearchServiceClientImpl client) {
        this.service = RestProxy.create(IndexesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchServiceClientIndexes to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "SearchServiceClientI")
    public interface IndexesService {
        @Post("/indexes")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SearchIndex>> create(
                @HostParam("endpoint") String endpoint,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SearchIndex index,
                Context context);

        @Post("/indexes")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SearchIndex> createSync(
                @HostParam("endpoint") String endpoint,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SearchIndex index,
                Context context);

        @Get("/indexes")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<ListIndexesResult>> list(
                @HostParam("endpoint") String endpoint,
                @QueryParam("$select") String select,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/indexes")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<ListIndexesResult> listSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("$select") String select,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/indexes('{indexName}')")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SearchIndex>> createOrUpdate(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @QueryParam("allowIndexDowntime") Boolean allowIndexDowntime,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("If-Match") String ifMatch,
                @HeaderParam("If-None-Match") String ifNoneMatch,
                @HeaderParam("Prefer") String prefer,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SearchIndex index,
                Context context);

        @Put("/indexes('{indexName}')")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SearchIndex> createOrUpdateSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @QueryParam("allowIndexDowntime") Boolean allowIndexDowntime,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("If-Match") String ifMatch,
                @HeaderParam("If-None-Match") String ifNoneMatch,
                @HeaderParam("Prefer") String prefer,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SearchIndex index,
                Context context);

        @Delete("/indexes('{indexName}')")
        @ExpectedResponses({204, 404})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<Void>> delete(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("If-Match") String ifMatch,
                @HeaderParam("If-None-Match") String ifNoneMatch,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/indexes('{indexName}')")
        @ExpectedResponses({204, 404})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<Void> deleteSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("If-Match") String ifMatch,
                @HeaderParam("If-None-Match") String ifNoneMatch,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/indexes('{indexName}')")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SearchIndex>> get(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/indexes('{indexName}')")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SearchIndex> getSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/indexes('{indexName}')/search.stats")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SearchIndexStatistics>> getStatistics(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/indexes('{indexName}')/search.stats")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SearchIndexStatistics> getStatisticsSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/indexes('{indexName}')/search.analyze")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<AnalyzeResult>> analyze(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") AnalyzeRequest request,
                Context context);

        @Post("/indexes('{indexName}')/search.analyze")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<AnalyzeResult> analyzeSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") AnalyzeRequest request,
                Context context);
    }

    /**
     * Creates a new search index.
     *
     * @param index The definition of the index to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createWithResponseAsync(SearchIndex index, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.create(
                                this.client.getEndpoint(),
                                xMsClientRequestId,
                                this.client.getApiVersion(),
                                accept,
                                index,
                                context));
    }

    /**
     * Creates a new search index.
     *
     * @param index The definition of the index to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createWithResponseAsync(
            SearchIndex index, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.create(
                this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept, index, context);
    }

    /**
     * Creates a new search index.
     *
     * @param index The definition of the index to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndex> createAsync(SearchIndex index, RequestOptions requestOptions) {
        return createWithResponseAsync(index, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search index.
     *
     * @param index The definition of the index to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndex> createAsync(SearchIndex index, RequestOptions requestOptions, Context context) {
        return createWithResponseAsync(index, requestOptions, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search index.
     *
     * @param index The definition of the index to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndex> createWithResponse(SearchIndex index, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createSync(
                this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept, index, context);
    }

    /**
     * Creates a new search index.
     *
     * @param index The definition of the index to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndex create(SearchIndex index, RequestOptions requestOptions) {
        return createWithResponse(index, requestOptions, Context.NONE).getValue();
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SearchIndex>> listSinglePageAsync(String select, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                        context ->
                                service.list(
                                        this.client.getEndpoint(),
                                        select,
                                        xMsClientRequestId,
                                        this.client.getApiVersion(),
                                        accept,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getIndexes(),
                                        null,
                                        null));
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SearchIndex>> listSinglePageAsync(
            String select, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.list(
                        this.client.getEndpoint(),
                        select,
                        xMsClientRequestId,
                        this.client.getApiVersion(),
                        accept,
                        context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getIndexes(),
                                        null,
                                        null));
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchIndex> listAsync(String select, RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listSinglePageAsync(select, requestOptions));
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchIndex> listAsync(String select, RequestOptions requestOptions, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(select, requestOptions, context));
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SearchIndex> listSinglePage(String select, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListIndexesResult> res =
                service.listSync(
                        this.client.getEndpoint(),
                        select,
                        xMsClientRequestId,
                        this.client.getApiVersion(),
                        accept,
                        Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getIndexes(), null, null);
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SearchIndex> listSinglePage(String select, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListIndexesResult> res =
                service.listSync(
                        this.client.getEndpoint(),
                        select,
                        xMsClientRequestId,
                        this.client.getApiVersion(),
                        accept,
                        context);
        return new PagedResponseBase<>(
                res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getIndexes(), null, null);
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchIndex> list(String select, RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listSinglePage(select, requestOptions, Context.NONE));
    }

    /**
     * Lists all indexes available for a search service.
     *
     * @param select Selects which top-level properties of the index definitions to retrieve. Specified as a
     *     comma-separated list of JSON property names, or `*` for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexes request as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchIndex> list(String select, RequestOptions requestOptions, Context context) {
        return new PagedIterable<>(() -> listSinglePage(select, requestOptions, context));
    }

    /**
     * Creates a new search index or updates an index if it already exists.
     *
     * @param indexName The definition of the index to create or update.
     * @param index The definition of the index to create or update.
     * @param allowIndexDowntime Allows new analyzers, tokenizers, token filters, or char filters to be added to an
     *     index by taking the index offline for at least a few seconds. This temporarily causes indexing and query
     *     requests to fail. Performance and write availability of the index can be impaired for several minutes after
     *     the index is updated, or longer for very large indexes.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createOrUpdateWithResponseAsync(
            String indexName,
            SearchIndex index,
            Boolean allowIndexDowntime,
            String ifMatch,
            String ifNoneMatch,
            RequestOptions requestOptions) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.createOrUpdate(
                                this.client.getEndpoint(),
                                indexName,
                                allowIndexDowntime,
                                xMsClientRequestId,
                                ifMatch,
                                ifNoneMatch,
                                prefer,
                                this.client.getApiVersion(),
                                accept,
                                index,
                                context));
    }

    /**
     * Creates a new search index or updates an index if it already exists.
     *
     * @param indexName The definition of the index to create or update.
     * @param index The definition of the index to create or update.
     * @param allowIndexDowntime Allows new analyzers, tokenizers, token filters, or char filters to be added to an
     *     index by taking the index offline for at least a few seconds. This temporarily causes indexing and query
     *     requests to fail. Performance and write availability of the index can be impaired for several minutes after
     *     the index is updated, or longer for very large indexes.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createOrUpdateWithResponseAsync(
            String indexName,
            SearchIndex index,
            Boolean allowIndexDowntime,
            String ifMatch,
            String ifNoneMatch,
            RequestOptions requestOptions,
            Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdate(
                this.client.getEndpoint(),
                indexName,
                allowIndexDowntime,
                xMsClientRequestId,
                ifMatch,
                ifNoneMatch,
                prefer,
                this.client.getApiVersion(),
                accept,
                index,
                context);
    }

    /**
     * Creates a new search index or updates an index if it already exists.
     *
     * @param indexName The definition of the index to create or update.
     * @param index The definition of the index to create or update.
     * @param allowIndexDowntime Allows new analyzers, tokenizers, token filters, or char filters to be added to an
     *     index by taking the index offline for at least a few seconds. This temporarily causes indexing and query
     *     requests to fail. Performance and write availability of the index can be impaired for several minutes after
     *     the index is updated, or longer for very large indexes.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndex> createOrUpdateAsync(
            String indexName,
            SearchIndex index,
            Boolean allowIndexDowntime,
            String ifMatch,
            String ifNoneMatch,
            RequestOptions requestOptions) {
        return createOrUpdateWithResponseAsync(
                        indexName, index, allowIndexDowntime, ifMatch, ifNoneMatch, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search index or updates an index if it already exists.
     *
     * @param indexName The definition of the index to create or update.
     * @param index The definition of the index to create or update.
     * @param allowIndexDowntime Allows new analyzers, tokenizers, token filters, or char filters to be added to an
     *     index by taking the index offline for at least a few seconds. This temporarily causes indexing and query
     *     requests to fail. Performance and write availability of the index can be impaired for several minutes after
     *     the index is updated, or longer for very large indexes.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndex> createOrUpdateAsync(
            String indexName,
            SearchIndex index,
            Boolean allowIndexDowntime,
            String ifMatch,
            String ifNoneMatch,
            RequestOptions requestOptions,
            Context context) {
        return createOrUpdateWithResponseAsync(
                        indexName, index, allowIndexDowntime, ifMatch, ifNoneMatch, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search index or updates an index if it already exists.
     *
     * @param indexName The definition of the index to create or update.
     * @param index The definition of the index to create or update.
     * @param allowIndexDowntime Allows new analyzers, tokenizers, token filters, or char filters to be added to an
     *     index by taking the index offline for at least a few seconds. This temporarily causes indexing and query
     *     requests to fail. Performance and write availability of the index can be impaired for several minutes after
     *     the index is updated, or longer for very large indexes.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndex> createOrUpdateWithResponse(
            String indexName,
            SearchIndex index,
            Boolean allowIndexDowntime,
            String ifMatch,
            String ifNoneMatch,
            RequestOptions requestOptions,
            Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdateSync(
                this.client.getEndpoint(),
                indexName,
                allowIndexDowntime,
                xMsClientRequestId,
                ifMatch,
                ifNoneMatch,
                prefer,
                this.client.getApiVersion(),
                accept,
                index,
                context);
    }

    /**
     * Creates a new search index or updates an index if it already exists.
     *
     * @param indexName The definition of the index to create or update.
     * @param index The definition of the index to create or update.
     * @param allowIndexDowntime Allows new analyzers, tokenizers, token filters, or char filters to be added to an
     *     index by taking the index offline for at least a few seconds. This temporarily causes indexing and query
     *     requests to fail. Performance and write availability of the index can be impaired for several minutes after
     *     the index is updated, or longer for very large indexes.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndex createOrUpdate(
            String indexName,
            SearchIndex index,
            Boolean allowIndexDowntime,
            String ifMatch,
            String ifNoneMatch,
            RequestOptions requestOptions) {
        return createOrUpdateWithResponse(
                        indexName, index, allowIndexDowntime, ifMatch, ifNoneMatch, requestOptions, Context.NONE)
                .getValue();
    }

    /**
     * Deletes a search index and all the documents it contains. This operation is permanent, with no recovery option.
     * Make sure you have a master copy of your index definition, data ingestion code, and a backup of the primary data
     * source in case you need to re-build the index.
     *
     * @param indexName The name of the index to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(
            String indexName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.delete(
                                this.client.getEndpoint(),
                                indexName,
                                xMsClientRequestId,
                                ifMatch,
                                ifNoneMatch,
                                this.client.getApiVersion(),
                                accept,
                                context));
    }

    /**
     * Deletes a search index and all the documents it contains. This operation is permanent, with no recovery option.
     * Make sure you have a master copy of your index definition, data ingestion code, and a backup of the primary data
     * source in case you need to re-build the index.
     *
     * @param indexName The name of the index to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(
            String indexName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.delete(
                this.client.getEndpoint(),
                indexName,
                xMsClientRequestId,
                ifMatch,
                ifNoneMatch,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Deletes a search index and all the documents it contains. This operation is permanent, with no recovery option.
     * Make sure you have a master copy of your index definition, data ingestion code, and a backup of the primary data
     * source in case you need to re-build the index.
     *
     * @param indexName The name of the index to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String indexName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return deleteWithResponseAsync(indexName, ifMatch, ifNoneMatch, requestOptions)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a search index and all the documents it contains. This operation is permanent, with no recovery option.
     * Make sure you have a master copy of your index definition, data ingestion code, and a backup of the primary data
     * source in case you need to re-build the index.
     *
     * @param indexName The name of the index to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
            String indexName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return deleteWithResponseAsync(indexName, ifMatch, ifNoneMatch, requestOptions, context)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a search index and all the documents it contains. This operation is permanent, with no recovery option.
     * Make sure you have a master copy of your index definition, data ingestion code, and a backup of the primary data
     * source in case you need to re-build the index.
     *
     * @param indexName The name of the index to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(
            String indexName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.deleteSync(
                this.client.getEndpoint(),
                indexName,
                xMsClientRequestId,
                ifMatch,
                ifNoneMatch,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Deletes a search index and all the documents it contains. This operation is permanent, with no recovery option.
     * Make sure you have a master copy of your index definition, data ingestion code, and a backup of the primary data
     * source in case you need to re-build the index.
     *
     * @param indexName The name of the index to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     *     matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     *     server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String indexName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        deleteWithResponse(indexName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    /**
     * Retrieves an index definition.
     *
     * @param indexName The name of the index to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> getWithResponseAsync(String indexName, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.get(
                                this.client.getEndpoint(),
                                indexName,
                                xMsClientRequestId,
                                this.client.getApiVersion(),
                                accept,
                                context));
    }

    /**
     * Retrieves an index definition.
     *
     * @param indexName The name of the index to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> getWithResponseAsync(
            String indexName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.get(
                this.client.getEndpoint(), indexName, xMsClientRequestId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Retrieves an index definition.
     *
     * @param indexName The name of the index to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndex> getAsync(String indexName, RequestOptions requestOptions) {
        return getWithResponseAsync(indexName, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an index definition.
     *
     * @param indexName The name of the index to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndex> getAsync(String indexName, RequestOptions requestOptions, Context context) {
        return getWithResponseAsync(indexName, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an index definition.
     *
     * @param indexName The name of the index to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndex> getWithResponse(String indexName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getSync(
                this.client.getEndpoint(), indexName, xMsClientRequestId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Retrieves an index definition.
     *
     * @param indexName The name of the index to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search index definition, which describes the fields and search behavior of an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndex get(String indexName, RequestOptions requestOptions) {
        return getWithResponse(indexName, requestOptions, Context.NONE).getValue();
    }

    /**
     * Returns statistics for the given index, including a document count and storage usage.
     *
     * @param indexName The name of the index for which to retrieve statistics.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return statistics for a given index along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexStatistics>> getStatisticsWithResponseAsync(
            String indexName, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.getStatistics(
                                this.client.getEndpoint(),
                                indexName,
                                xMsClientRequestId,
                                this.client.getApiVersion(),
                                accept,
                                context));
    }

    /**
     * Returns statistics for the given index, including a document count and storage usage.
     *
     * @param indexName The name of the index for which to retrieve statistics.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return statistics for a given index along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexStatistics>> getStatisticsWithResponseAsync(
            String indexName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getStatistics(
                this.client.getEndpoint(), indexName, xMsClientRequestId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns statistics for the given index, including a document count and storage usage.
     *
     * @param indexName The name of the index for which to retrieve statistics.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return statistics for a given index on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexStatistics> getStatisticsAsync(String indexName, RequestOptions requestOptions) {
        return getStatisticsWithResponseAsync(indexName, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns statistics for the given index, including a document count and storage usage.
     *
     * @param indexName The name of the index for which to retrieve statistics.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return statistics for a given index on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexStatistics> getStatisticsAsync(
            String indexName, RequestOptions requestOptions, Context context) {
        return getStatisticsWithResponseAsync(indexName, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns statistics for the given index, including a document count and storage usage.
     *
     * @param indexName The name of the index for which to retrieve statistics.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return statistics for a given index along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndexStatistics> getStatisticsWithResponse(
            String indexName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getStatisticsSync(
                this.client.getEndpoint(), indexName, xMsClientRequestId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns statistics for the given index, including a document count and storage usage.
     *
     * @param indexName The name of the index for which to retrieve statistics.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return statistics for a given index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndexStatistics getStatistics(String indexName, RequestOptions requestOptions) {
        return getStatisticsWithResponse(indexName, requestOptions, Context.NONE).getValue();
    }

    /**
     * Shows how an analyzer breaks text into tokens.
     *
     * @param indexName The name of the index for which to test an analyzer.
     * @param request The text and analyzer or analysis components to test.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of testing an analyzer on text along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResult>> analyzeWithResponseAsync(
            String indexName, AnalyzeRequest request, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.analyze(
                                this.client.getEndpoint(),
                                indexName,
                                xMsClientRequestId,
                                this.client.getApiVersion(),
                                accept,
                                request,
                                context));
    }

    /**
     * Shows how an analyzer breaks text into tokens.
     *
     * @param indexName The name of the index for which to test an analyzer.
     * @param request The text and analyzer or analysis components to test.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of testing an analyzer on text along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResult>> analyzeWithResponseAsync(
            String indexName, AnalyzeRequest request, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.analyze(
                this.client.getEndpoint(),
                indexName,
                xMsClientRequestId,
                this.client.getApiVersion(),
                accept,
                request,
                context);
    }

    /**
     * Shows how an analyzer breaks text into tokens.
     *
     * @param indexName The name of the index for which to test an analyzer.
     * @param request The text and analyzer or analysis components to test.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of testing an analyzer on text on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResult> analyzeAsync(String indexName, AnalyzeRequest request, RequestOptions requestOptions) {
        return analyzeWithResponseAsync(indexName, request, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Shows how an analyzer breaks text into tokens.
     *
     * @param indexName The name of the index for which to test an analyzer.
     * @param request The text and analyzer or analysis components to test.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of testing an analyzer on text on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResult> analyzeAsync(
            String indexName, AnalyzeRequest request, RequestOptions requestOptions, Context context) {
        return analyzeWithResponseAsync(indexName, request, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Shows how an analyzer breaks text into tokens.
     *
     * @param indexName The name of the index for which to test an analyzer.
     * @param request The text and analyzer or analysis components to test.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of testing an analyzer on text along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeResult> analyzeWithResponse(
            String indexName, AnalyzeRequest request, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.analyzeSync(
                this.client.getEndpoint(),
                indexName,
                xMsClientRequestId,
                this.client.getApiVersion(),
                accept,
                request,
                context);
    }

    /**
     * Shows how an analyzer breaks text into tokens.
     *
     * @param indexName The name of the index for which to test an analyzer.
     * @param request The text and analyzer or analysis components to test.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of testing an analyzer on text.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeResult analyze(String indexName, AnalyzeRequest request, RequestOptions requestOptions) {
        return analyzeWithResponse(indexName, request, requestOptions, Context.NONE).getValue();
    }
}
