// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** The algorithm used for indexing and querying. */
public final class VectorSearchAlgorithmKind extends ExpandableStringEnum<VectorSearchAlgorithmKind> {
    /** HNSW (Hierarchical Navigable Small World), a type of approximate nearest neighbors algorithm. */
    public static final VectorSearchAlgorithmKind HNSW = fromString("hnsw");

    /** Exhaustive KNN algorithm which will perform brute-force search. */
    public static final VectorSearchAlgorithmKind EXHAUSTIVE_KNN = fromString("exhaustiveKnn");

    /**
     * Creates a new instance of VectorSearchAlgorithmKind value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VectorSearchAlgorithmKind() {}

    /**
     * Creates or finds a VectorSearchAlgorithmKind from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorSearchAlgorithmKind.
     */
    public static VectorSearchAlgorithmKind fromString(String name) {
        return fromString(name, VectorSearchAlgorithmKind.class);
    }

    /**
     * Gets known VectorSearchAlgorithmKind values.
     *
     * @return known VectorSearchAlgorithmKind values.
     */
    public static Collection<VectorSearchAlgorithmKind> values() {
        return values(VectorSearchAlgorithmKind.class);
    }
}
