// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.VectorSearchAlgorithmKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Contains configuration options specific to the exhaustive KNN algorithm used during querying, which will perform
 * brute-force search across the entire vector index.
 */
@Fluent
public final class ExhaustiveKnnAlgorithmConfiguration extends VectorSearchAlgorithmConfiguration {
    /*
     * Contains the parameters specific to exhaustive KNN algorithm.
     */
    private ExhaustiveKnnParameters parameters;

    /**
     * Creates an instance of ExhaustiveKnnAlgorithmConfiguration class.
     *
     * @param name the name value to set.
     */
    public ExhaustiveKnnAlgorithmConfiguration(String name) {
        super(name);
    }

    /**
     * Get the parameters property: Contains the parameters specific to exhaustive KNN algorithm.
     *
     * @return the parameters value.
     */
    public ExhaustiveKnnParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Contains the parameters specific to exhaustive KNN algorithm.
     *
     * @param parameters the parameters value to set.
     * @return the ExhaustiveKnnAlgorithmConfiguration object itself.
     */
    public ExhaustiveKnnAlgorithmConfiguration setParameters(ExhaustiveKnnParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString(VectorSearchAlgorithmKind.EXHAUSTIVE_KNN, null));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeJsonField("exhaustiveKnnParameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExhaustiveKnnAlgorithmConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExhaustiveKnnAlgorithmConfiguration if the JsonReader was pointing to an instance of it,
     *     or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the ExhaustiveKnnAlgorithmConfiguration.
     */
    public static ExhaustiveKnnAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean nameFound = false;
                    String name = null;
                    ExhaustiveKnnParameters parameters = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("kind".equals(fieldName)) {
                            String kind = reader.getString();
                            if (!"exhaustiveKnn".equals(kind)) {
                                throw new IllegalStateException(
                                        "'kind' was expected to be non-null and equal to 'exhaustiveKnn'. The found 'kind' was '"
                                                + kind
                                                + "'.");
                            }
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                            nameFound = true;
                        } else if ("exhaustiveKnnParameters".equals(fieldName)) {
                            parameters = ExhaustiveKnnParameters.fromJson(reader);
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (nameFound) {
                        ExhaustiveKnnAlgorithmConfiguration deserializedExhaustiveKnnAlgorithmConfiguration =
                                new ExhaustiveKnnAlgorithmConfiguration(name);
                        deserializedExhaustiveKnnAlgorithmConfiguration.parameters = parameters;

                        return deserializedExhaustiveKnnAlgorithmConfiguration;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!nameFound) {
                        missingProperties.add("name");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
