// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Defines the names of all tokenizers supported by the search engine. */
public final class LexicalTokenizerName extends ExpandableStringEnum<LexicalTokenizerName> {
    /**
     * Grammar-based tokenizer that is suitable for processing most European-language documents. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/standard/ClassicTokenizer.html.
     */
    public static final LexicalTokenizerName CLASSIC = fromString("classic");

    /**
     * Tokenizes the input from an edge into n-grams of the given size(s). See
     * https://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ngram/EdgeNGramTokenizer.html.
     */
    public static final LexicalTokenizerName EDGE_NGRAM = fromString("edgeNGram");

    /**
     * Emits the entire input as a single token. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/KeywordTokenizer.html.
     */
    public static final LexicalTokenizerName KEYWORD = fromString("keyword_v2");

    /**
     * Divides text at non-letters. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/LetterTokenizer.html.
     */
    public static final LexicalTokenizerName LETTER = fromString("letter");

    /**
     * Divides text at non-letters and converts them to lower case. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/LowerCaseTokenizer.html.
     */
    public static final LexicalTokenizerName LOWERCASE = fromString("lowercase");

    /** Divides text using language-specific rules. */
    public static final LexicalTokenizerName MICROSOFT_LANGUAGE_TOKENIZER = fromString("microsoft_language_tokenizer");

    /** Divides text using language-specific rules and reduces words to their base forms. */
    public static final LexicalTokenizerName MICROSOFT_LANGUAGE_STEMMING_TOKENIZER =
            fromString("microsoft_language_stemming_tokenizer");

    /**
     * Tokenizes the input into n-grams of the given size(s). See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ngram/NGramTokenizer.html.
     */
    public static final LexicalTokenizerName NGRAM = fromString("nGram");

    /**
     * Tokenizer for path-like hierarchies. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/path/PathHierarchyTokenizer.html.
     */
    public static final LexicalTokenizerName PATH_HIERARCHY = fromString("path_hierarchy_v2");

    /**
     * Tokenizer that uses regex pattern matching to construct distinct tokens. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/pattern/PatternTokenizer.html.
     */
    public static final LexicalTokenizerName PATTERN = fromString("pattern");

    /**
     * Standard Lucene analyzer; Composed of the standard tokenizer, lowercase filter and stop filter. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/standard/StandardTokenizer.html.
     */
    public static final LexicalTokenizerName STANDARD = fromString("standard_v2");

    /**
     * Tokenizes urls and emails as one token. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/standard/UAX29URLEmailTokenizer.html.
     */
    public static final LexicalTokenizerName UAX_URL_EMAIL = fromString("uax_url_email");

    /**
     * Divides text at whitespace. See
     * http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/WhitespaceTokenizer.html.
     */
    public static final LexicalTokenizerName WHITESPACE = fromString("whitespace");

    /**
     * Creates a new instance of LexicalTokenizerName value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LexicalTokenizerName() {}

    /**
     * Creates or finds a LexicalTokenizerName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding LexicalTokenizerName.
     */
    public static LexicalTokenizerName fromString(String name) {
        return fromString(name, LexicalTokenizerName.class);
    }

    /**
     * Gets known LexicalTokenizerName values.
     *
     * @return known LexicalTokenizerName values.
     */
    public static Collection<LexicalTokenizerName> values() {
        return values(LexicalTokenizerName.class);
    }
}
