// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Flexibly separates text into terms via a regular expression pattern. This analyzer is implemented using Apache
 * Lucene.
 */
@Fluent
public final class PatternAnalyzer extends LexicalAnalyzer {

    /*
     * A value indicating whether terms should be lower-cased. Default is true.
     */
    private Boolean lowerCaseTerms;

    /*
     * A regular expression pattern to match token separators. Default is an expression that matches one or more
     * non-word characters.
     */
    private String pattern;

    /*
     * Regular expression flags.
     */
    private RegexFlags flags;

    /*
     * A list of stopwords.
     */
    private List<String> stopwords;

    /**
     * Creates an instance of PatternAnalyzer class.
     *
     * @param name the name value to set.
     */
    public PatternAnalyzer(String name) {
        super(name);
    }

    /**
     * Get the lowerCaseTerms property: A value indicating whether terms should be lower-cased. Default is true.
     *
     * @return the lowerCaseTerms value.
     */
    public Boolean areLowerCaseTerms() {
        return this.lowerCaseTerms;
    }

    /**
     * Set the lowerCaseTerms property: A value indicating whether terms should be lower-cased. Default is true.
     *
     * @param lowerCaseTerms the lowerCaseTerms value to set.
     * @return the PatternAnalyzer object itself.
     */
    public PatternAnalyzer setLowerCaseTerms(Boolean lowerCaseTerms) {
        this.lowerCaseTerms = lowerCaseTerms;
        return this;
    }

    /**
     * Get the pattern property: A regular expression pattern to match token separators. Default is an expression that
     * matches one or more non-word characters.
     *
     * @return the pattern value.
     */
    public String getPattern() {
        return this.pattern;
    }

    /**
     * Set the pattern property: A regular expression pattern to match token separators. Default is an expression that
     * matches one or more non-word characters.
     *
     * @param pattern the pattern value to set.
     * @return the PatternAnalyzer object itself.
     */
    public PatternAnalyzer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    /**
     * Get the flags property: Regular expression flags.
     *
     * @return the flags value.
     */
    public List<RegexFlags> getFlags() {
        if (this.flags == null) {
            return null;
        } else {
            String[] flagStrings = this.flags.toString().split("\\|");
            return java.util.Arrays.stream(flagStrings).map(RegexFlags::fromString).collect(Collectors.toList());
        }
    }

    /**
     * Set the flags property: Regular expression flags.
     *
     * @param flags the flags value to set.
     * @return the PatternAnalyzer object itself.
     */
    public PatternAnalyzer setFlags(List<RegexFlags> flags) {
        if (flags == null) {
            this.flags = null;
        } else {
            String flagString = flags.stream().map(RegexFlags::toString).collect(Collectors.joining("|"));
            this.flags = RegexFlags.fromString(flagString);
        }
        return this;
    }

    /**
     * Get the stopwords property: A list of stopwords.
     *
     * @return the stopwords value.
     */
    public List<String> getStopwords() {
        return this.stopwords;
    }

    /**
     * Set the stopwords property: A list of stopwords.
     *
     * @param stopwords the stopwords value to set.
     * @return the PatternAnalyzer object itself.
     */
    public PatternAnalyzer setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.PatternAnalyzer");
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeBooleanField("lowercase", this.lowerCaseTerms);
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("flags", Objects.toString(this.flags, null));
        jsonWriter.writeArrayField("stopwords", this.stopwords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatternAnalyzer from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatternAnalyzer if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the PatternAnalyzer.
     */
    public static PatternAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean nameFound = false;
                    String name = null;
                    Boolean lowerCaseTerms = null;
                    String pattern = null;
                    RegexFlags flags = null;
                    List<String> stopwords = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Azure.Search.PatternAnalyzer".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PatternAnalyzer'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                            nameFound = true;
                        } else if ("lowercase".equals(fieldName)) {
                            lowerCaseTerms = reader.getNullable(JsonReader::getBoolean);
                        } else if ("pattern".equals(fieldName)) {
                            pattern = reader.getString();
                        } else if ("flags".equals(fieldName)) {
                            flags = RegexFlags.fromString(reader.getString());
                        } else if ("stopwords".equals(fieldName)) {
                            stopwords = reader.readArray(reader1 -> reader1.getString());
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (nameFound) {
                        PatternAnalyzer deserializedPatternAnalyzer = new PatternAnalyzer(name);
                        deserializedPatternAnalyzer.lowerCaseTerms = lowerCaseTerms;
                        deserializedPatternAnalyzer.pattern = pattern;
                        deserializedPatternAnalyzer.flags = flags;
                        deserializedPatternAnalyzer.stopwords = stopwords;
                        return deserializedPatternAnalyzer;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!nameFound) {
                        missingProperties.add("name");
                    }
                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }

    /**
     * Set the stopwords property: A list of stopwords.
     *
     * @param stopwords the stopwords value to set.
     * @return the PatternAnalyzer object itself.
     */
    public PatternAnalyzer setStopwords(String... stopwords) {
        this.stopwords = (stopwords == null) ? null : java.util.Arrays.asList(stopwords);
        return this;
    }

    /**
     * Set the flags property: Regular expression flags.
     *
     * @param flags the flags value to set.
     * @return the PatternAnalyzer object itself.
     */
    public PatternAnalyzer setFlags(RegexFlags... flags) {
        if (flags == null) {
            this.flags = null;
            return this;
        } else {
            return setFlags(java.util.Arrays.asList(flags));
        }
    }
}
