// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Tokenizer that uses regex pattern matching to construct distinct tokens. This tokenizer is implemented using Apache
 * Lucene.
 */
@Fluent
public final class PatternTokenizer extends LexicalTokenizer {

    /*
     * A regular expression pattern to match token separators. Default is an expression that matches one or more
     * non-word characters.
     */
    private String pattern;

    /*
     * Regular expression flags.
     */
    private RegexFlags flags;

    /*
     * The zero-based ordinal of the matching group in the regular expression pattern to extract into tokens. Use -1 if
     * you want to use the entire pattern to split the input into tokens, irrespective of matching groups. Default is
     * -1.
     */
    private Integer group;

    /**
     * Creates an instance of PatternTokenizer class.
     *
     * @param name the name value to set.
     */
    public PatternTokenizer(String name) {
        super(name);
    }

    /**
     * Get the pattern property: A regular expression pattern to match token separators. Default is an expression that
     * matches one or more non-word characters.
     *
     * @return the pattern value.
     */
    public String getPattern() {
        return this.pattern;
    }

    /**
     * Set the pattern property: A regular expression pattern to match token separators. Default is an expression that
     * matches one or more non-word characters.
     *
     * @param pattern the pattern value to set.
     * @return the PatternTokenizer object itself.
     */
    public PatternTokenizer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    /**
     * Get the flags property: Regular expression flags.
     *
     * @return the flags value.
     */
    public List<RegexFlags> getFlags() {
        if (this.flags == null) {
            return null;
        } else {
            String[] flagStrings = this.flags.toString().split("\\|");
            return java.util.Arrays.stream(flagStrings).map(RegexFlags::fromString).collect(Collectors.toList());
        }
    }

    /**
     * Set the flags property: Regular expression flags.
     *
     * @param flags the flags value to set.
     * @return the PatternTokenizer object itself.
     */
    public PatternTokenizer setFlags(List<RegexFlags> flags) {
        if (flags == null) {
            this.flags = null;
        } else {
            String flagString = flags.stream().map(RegexFlags::toString).collect(Collectors.joining("|"));
            this.flags = RegexFlags.fromString(flagString);
        }
        return this;
    }

    /**
     * Get the group property: The zero-based ordinal of the matching group in the regular expression pattern to extract
     * into tokens. Use -1 if you want to use the entire pattern to split the input into tokens, irrespective of
     * matching groups. Default is -1.
     *
     * @return the group value.
     */
    public Integer getGroup() {
        return this.group;
    }

    /**
     * Set the group property: The zero-based ordinal of the matching group in the regular expression pattern to extract
     * into tokens. Use -1 if you want to use the entire pattern to split the input into tokens, irrespective of
     * matching groups. Default is -1.
     *
     * @param group the group value to set.
     * @return the PatternTokenizer object itself.
     */
    public PatternTokenizer setGroup(Integer group) {
        this.group = group;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.PatternTokenizer");
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("flags", Objects.toString(this.flags, null));
        jsonWriter.writeNumberField("group", this.group);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatternTokenizer from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatternTokenizer if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the PatternTokenizer.
     */
    public static PatternTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean nameFound = false;
                    String name = null;
                    String pattern = null;
                    RegexFlags flags = null;
                    Integer group = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Azure.Search.PatternTokenizer".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PatternTokenizer'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                            nameFound = true;
                        } else if ("pattern".equals(fieldName)) {
                            pattern = reader.getString();
                        } else if ("flags".equals(fieldName)) {
                            flags = RegexFlags.fromString(reader.getString());
                        } else if ("group".equals(fieldName)) {
                            group = reader.getNullable(JsonReader::getInt);
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (nameFound) {
                        PatternTokenizer deserializedPatternTokenizer = new PatternTokenizer(name);
                        deserializedPatternTokenizer.pattern = pattern;
                        deserializedPatternTokenizer.flags = flags;
                        deserializedPatternTokenizer.group = group;
                        return deserializedPatternTokenizer;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!nameFound) {
                        missingProperties.add("name");
                    }
                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }

    /**
     * Set the flags property: Regular expression flags.
     *
     * @param flags the flags value to set.
     * @return the PatternTokenizer object itself.
     */
    public PatternTokenizer setFlags(RegexFlags... flags) {
        if (flags == null) {
            this.flags = null;
            return this;
        } else {
            return setFlags(java.util.Arrays.asList(flags));
        }
    }
}
