// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** A string indicating what maskingMode to use to mask the personal information detected in the input text. */
public final class PiiDetectionSkillMaskingMode extends ExpandableStringEnum<PiiDetectionSkillMaskingMode> {
    /** No masking occurs and the maskedText output will not be returned. */
    public static final PiiDetectionSkillMaskingMode NONE = fromString("none");

    /**
     * Replaces the detected entities with the character given in the maskingCharacter parameter. The character will be
     * repeated to the length of the detected entity so that the offsets will correctly correspond to both the input
     * text as well as the output maskedText.
     */
    public static final PiiDetectionSkillMaskingMode REPLACE = fromString("replace");

    /**
     * Creates a new instance of PiiDetectionSkillMaskingMode value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PiiDetectionSkillMaskingMode() {}

    /**
     * Creates or finds a PiiDetectionSkillMaskingMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding PiiDetectionSkillMaskingMode.
     */
    public static PiiDetectionSkillMaskingMode fromString(String name) {
        return fromString(name, PiiDetectionSkillMaskingMode.class);
    }

    /**
     * Gets known PiiDetectionSkillMaskingMode values.
     *
     * @return known PiiDetectionSkillMaskingMode values.
     */
    public static Collection<PiiDetectionSkillMaskingMode> values() {
        return values(PiiDetectionSkillMaskingMode.class);
    }
}
